/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.session.capability;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;
import org.neo4j.ogm.domain.gh651.PersistentCategory;
import org.neo4j.ogm.domain.gh651.SomeEntity;
import org.neo4j.ogm.domain.gh651.SomeRelationshipEntity;
import org.neo4j.ogm.driver.AbstractConfigurableDriver;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.request.GraphModelRequest;
import org.neo4j.ogm.request.GraphRowListModelRequest;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.delegates.LoadByIdsDelegate;
import org.neo4j.ogm.session.delegates.LoadByTypeDelegate;
import org.neo4j.ogm.session.delegates.LoadOneDelegate;
import org.neo4j.ogm.session.transaction.support.TransactionalUnitOfWork;
import org.neo4j.ogm.transaction.Transaction;
import org.neo4j.ogm.transaction.TransactionManager;

@RunWith(value=MockitoJUnitRunner.class)
public class StrictQueryingTest {
    private final MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.gh651"});
    @Spy
    Neo4jSession neo4jSession = new Neo4jSession(this.metaData, true, (Driver)new AbstractConfigurableDriver(){

        public Function<TransactionManager, BiFunction<Transaction.Type, Iterable<String>, Transaction>> getTransactionFactorySupplier() {
            return transactionManager -> null;
        }

        public void close() {
        }

        public Request request(Transaction transaction) {
            return null;
        }
    });
    @Mock
    Request request;

    @Before
    public void prepareMocks() {
        ((Neo4jSession)Mockito.doReturn((Object)this.metaData).when((Object)this.neo4jSession)).metaData();
        ((Neo4jSession)Mockito.doReturn((Object)this.request).when((Object)this.neo4jSession)).requestHandler();
        ((Neo4jSession)Mockito.doAnswer(invocation -> ((TransactionalUnitOfWork)invocation.getArgument(0)).doInTransaction()).when((Object)this.neo4jSession)).doInTransaction((TransactionalUnitOfWork)Mockito.any(TransactionalUnitOfWork.class), (Transaction.Type)Mockito.any(Transaction.Type.class));
        Response<GraphModel> response = new Response<GraphModel>(){

            public GraphModel next() {
                return null;
            }

            public void close() {
            }

            public String[] columns() {
                return new String[0];
            }
        };
        ((Request)Mockito.doReturn((Object)response).when((Object)this.request)).execute((GraphModelRequest)Mockito.any(GraphModelRequest.class));
        ((Request)Mockito.doReturn((Object)response).when((Object)this.request)).execute((GraphRowListModelRequest)Mockito.any(GraphRowListModelRequest.class));
    }

    @Test
    public void shouldUseOnlyOneLabelForStandardEntity() {
        LoadByIdsDelegate delegate = new LoadByIdsDelegate(this.neo4jSession);
        delegate.loadAll(SomeEntity.class, Arrays.asList(1L, 2L));
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(GraphModelRequest.class);
        ((Request)Mockito.verify((Object)this.request)).execute((GraphModelRequest)argumentCaptor.capture());
        Assertions.assertThat((String)((GraphModelRequest)argumentCaptor.getValue()).getStatement()).isEqualTo((Object)"MATCH (n:`SomeEntity`) WHERE ID(n) IN { ids } WITH n MATCH p=(n)-[*0..1]-(m) RETURN p");
    }

    @Test
    public void shouldUseOnlyOneLabelForOneStandardEntity() {
        LoadOneDelegate delegate = new LoadOneDelegate(this.neo4jSession);
        delegate.load(SomeEntity.class, (Serializable)Long.valueOf(4711L));
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(GraphModelRequest.class);
        ((Request)Mockito.verify((Object)this.request)).execute((GraphModelRequest)argumentCaptor.capture());
        Assertions.assertThat((String)((GraphModelRequest)argumentCaptor.getValue()).getStatement()).isEqualTo((Object)"MATCH (n:`SomeEntity`) WHERE ID(n) = { id } WITH n MATCH p=(n)-[*0..1]-(m) RETURN p");
    }

    @Test
    public void shouldUseOnlyOneLabelForAllStandardEntities() {
        LoadByTypeDelegate delegate = new LoadByTypeDelegate(this.neo4jSession);
        delegate.loadAll(SomeEntity.class);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(GraphModelRequest.class);
        ((Request)Mockito.verify((Object)this.request)).execute((GraphModelRequest)argumentCaptor.capture());
        Assertions.assertThat((String)((GraphModelRequest)argumentCaptor.getValue()).getStatement()).isEqualTo((Object)"MATCH (n:`SomeEntity`) WITH n MATCH p=(n)-[*0..1]-(m) RETURN p");
    }

    @Test
    public void shouldUseAllLabelsInInheritanceScenario() {
        LoadByIdsDelegate delegate = new LoadByIdsDelegate(this.neo4jSession);
        delegate.loadAll(PersistentCategory.class, Collections.singletonList("abc"));
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(GraphModelRequest.class);
        ((Request)Mockito.verify((Object)this.request)).execute((GraphModelRequest)argumentCaptor.capture());
        Assertions.assertThat((String)((GraphModelRequest)argumentCaptor.getValue()).getStatement()).isEqualTo((Object)"MATCH (n:`Category`:`Entity`) WHERE n.`uuid` IN { ids } WITH n MATCH p=(n)-[*0..1]-(m) RETURN p");
    }

    @Test
    public void shouldUseAllLabelsForOneEntityInInheritanceScenario() {
        LoadOneDelegate delegate = new LoadOneDelegate(this.neo4jSession);
        delegate.load(PersistentCategory.class, (Serializable)((Object)"abc"));
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(GraphModelRequest.class);
        ((Request)Mockito.verify((Object)this.request)).execute((GraphModelRequest)argumentCaptor.capture());
        Assertions.assertThat((String)((GraphModelRequest)argumentCaptor.getValue()).getStatement()).isEqualTo((Object)"MATCH (n:`Category`:`Entity`) WHERE n.`uuid` = { id } WITH n MATCH p=(n)-[*0..1]-(m) RETURN p");
    }

    @Test
    public void shouldUseAllLabelsForAllEntitiesInInheritanceScenario() {
        LoadByTypeDelegate delegate = new LoadByTypeDelegate(this.neo4jSession);
        delegate.loadAll(PersistentCategory.class);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(GraphModelRequest.class);
        ((Request)Mockito.verify((Object)this.request)).execute((GraphModelRequest)argumentCaptor.capture());
        Assertions.assertThat((String)((GraphModelRequest)argumentCaptor.getValue()).getStatement()).isEqualTo((Object)"MATCH (n:`Category`:`Entity`) WITH n MATCH p=(n)-[*0..1]-(m) RETURN p");
    }

    @Test
    public void shouldUseOnlyOneLabelForRelationshipEntities() {
        LoadByIdsDelegate delegate = new LoadByIdsDelegate(this.neo4jSession);
        delegate.loadAll(SomeRelationshipEntity.class, Arrays.asList(1L, 2L));
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(GraphModelRequest.class);
        ((Request)Mockito.verify((Object)this.request)).execute((GraphModelRequest)argumentCaptor.capture());
        Assertions.assertThat((String)((GraphModelRequest)argumentCaptor.getValue()).getStatement()).startsWith((CharSequence)"MATCH ()-[r0:`SOME_RELATIONSHIP`]-() WHERE ID(r0) IN {ids}");
    }

    @Test
    public void shouldUseOnlyOneLabelForOneRelationshipEntity() {
        LoadOneDelegate delegate = new LoadOneDelegate(this.neo4jSession);
        delegate.load(SomeRelationshipEntity.class, (Serializable)Long.valueOf(1L));
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(GraphModelRequest.class);
        ((Request)Mockito.verify((Object)this.request)).execute((GraphModelRequest)argumentCaptor.capture());
        Assertions.assertThat((String)((GraphModelRequest)argumentCaptor.getValue()).getStatement()).startsWith((CharSequence)"MATCH ()-[r0:`SOME_RELATIONSHIP`]->() WHERE ID(r0)={id}");
    }

    @Test
    public void shouldUseOnlyOneLabelForAllRelationshipEntities() {
        LoadByTypeDelegate delegate = new LoadByTypeDelegate(this.neo4jSession);
        delegate.loadAll(SomeRelationshipEntity.class);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(GraphRowListModelRequest.class);
        ((Request)Mockito.verify((Object)this.request)).execute((GraphRowListModelRequest)argumentCaptor.capture());
        Assertions.assertThat((String)((GraphRowListModelRequest)argumentCaptor.getValue()).getStatement()).startsWith((CharSequence)"MATCH ()-[r0:`SOME_RELATIONSHIP`]-()");
    }
}

