/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.session.events;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.domain.filesystem.Document;
import org.neo4j.ogm.domain.filesystem.Folder;
import org.neo4j.ogm.persistence.session.events.EventTestBaseClass;
import org.neo4j.ogm.session.event.Event;

public class AssociatedObjectsTest
extends EventTestBaseClass {
    @Test
    public void shouldNotFireEventsOnAssociatedFolderThatHasNotChanged() {
        this.a.setName("newA");
        this.session.save((Object)this.a);
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((int)eventListener.count()).isEqualTo(2);
    }

    @Test
    public void shouldFireEventsForAllDirtyObjectsThatAreReachableFromTheRoot() {
        this.a.setName("newA");
        this.b.setName("newB");
        this.c.setName("newC");
        this.session.save((Object)this.a);
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.b, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.b, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.c, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.c, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((int)eventListener.count()).isEqualTo(6);
    }

    @Test
    public void shouldFireEventsForAssociatedObjectsWhenDeletingParentObjectWithInconsistentDomainModel() {
        this.session.delete((Object)this.a);
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.PRE_DELETE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.POST_DELETE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((int)eventListener.count()).isEqualTo(4);
    }

    @Test
    public void shouldFireEventsForAssociatedObjectsWhenDeletingParentObjectWithConsistentDomainModel() {
        this.folder.getDocuments().remove(this.a);
        this.session.delete((Object)this.a);
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.PRE_DELETE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.POST_DELETE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((int)eventListener.count()).isEqualTo(4);
    }

    @Test
    public void shouldFireEventsWhenAddNewObjectInCollectionAndSaveCollection() {
        Document z = new Document();
        z.setFolder(this.folder);
        this.folder.getDocuments().add(z);
        this.session.save((Object)this.folder);
        Assertions.assertThat((boolean)eventListener.captured(z, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(z, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((int)eventListener.count()).isEqualTo(4);
    }

    @Test
    public void shouldFireEventsWhenAddNewObjectToCollectionAndSaveNewObject() {
        Document z = new Document();
        z.setFolder(this.folder);
        this.folder.getDocuments().add(z);
        this.session.save((Object)z);
        Assertions.assertThat((boolean)eventListener.captured(z, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(z, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((int)eventListener.count()).isEqualTo(4);
    }

    @Test
    public void shouldFireEventsWhenAddExistingObjectToCollectionAndSaveExistingObject() {
        this.d.setFolder(this.folder);
        this.folder.getDocuments().add(this.d);
        this.session.save((Object)this.d);
        Assertions.assertThat((boolean)eventListener.captured(this.d, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.d, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((int)eventListener.count()).isEqualTo(4);
    }

    @Test
    public void shouldFireEventsWhenSetAssociatedObjectToNewAnonymousObject() {
        this.a.setFolder(new Folder());
        this.folder.getDocuments().remove(this.a);
        this.session.save((Object)this.a);
        Assertions.assertThat((boolean)eventListener.captured(new Folder(), Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(new Folder(), Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((int)eventListener.count()).isEqualTo(6);
    }

    @Test
    public void shouldFireEventsWhenAddExistingObjectToCollectionAndSaveCollection() {
        Assertions.assertThat((Object)this.d.getFolder()).isNull();
        this.d.setFolder(this.folder);
        this.folder.getDocuments().add(this.d);
        this.session.save((Object)this.folder);
        Assertions.assertThat((boolean)eventListener.captured(this.d, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.d, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((int)eventListener.count()).isEqualTo(4);
    }

    @Test
    public void shouldFireEventsWhenItemDisassociatedFromContainerAndSaveContainer() {
        this.folder.getDocuments().remove(this.a);
        this.a.setFolder(null);
        this.session.save((Object)this.folder);
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((int)eventListener.count()).isEqualTo(4);
    }

    @Test
    public void shouldFireEventsWhenItemDisassociatedFromContainerAndSaveItem() {
        this.folder.getDocuments().remove(this.a);
        this.a.setFolder(null);
        this.session.save((Object)this.a);
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((int)eventListener.count()).isEqualTo(4);
    }
}

