/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.session.events;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.domain.cineasts.annotated.Actor;
import org.neo4j.ogm.domain.filesystem.Document;
import org.neo4j.ogm.persistence.session.events.EventTestBaseClass;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.event.Event;

public class CollectionsTest
extends EventTestBaseClass {
    @Test
    public void shouldFireEventsWhenSavingACollection() {
        this.a.setName("newA");
        this.b.setName("newB");
        this.c.setName("newC");
        this.session.save(Arrays.asList(this.a, this.b, this.c));
        Assertions.assertThat((int)eventListener.count()).isEqualTo(6);
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.b, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.b, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.c, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.c, Event.TYPE.POST_SAVE)).isTrue();
    }

    @Test
    public void shouldFireEventsWhenDeletingACollection() {
        this.session.delete(Arrays.asList(this.a, this.b, this.c));
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.PRE_DELETE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.POST_DELETE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.b, Event.TYPE.PRE_DELETE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.b, Event.TYPE.POST_DELETE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.c, Event.TYPE.PRE_DELETE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.c, Event.TYPE.POST_DELETE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((int)eventListener.count()).isEqualTo(8);
    }

    @Test
    public void shouldFireEventWhenDeletingAllObjectsOfASpecifiedType() {
        this.session.deleteAll(Document.class);
        Assertions.assertThat((int)eventListener.count()).isEqualTo(2);
        Assertions.assertThat((boolean)eventListener.captured(Document.class, Event.TYPE.PRE_DELETE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(Document.class, Event.TYPE.POST_DELETE)).isTrue();
    }

    @Test
    public void shouldFireEventsWhenDeletingObjectsOfDifferentTypes() {
        this.session.delete(Arrays.asList(this.folder, this.knowsJB));
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.PRE_DELETE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.folder, Event.TYPE.POST_DELETE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.knowsJB, Event.TYPE.PRE_DELETE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.knowsJB, Event.TYPE.POST_DELETE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.b, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.b, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.c, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.c, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.jim, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.jim, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.bruce, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.bruce, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((int)eventListener.count()).isEqualTo(14);
    }

    @Test
    public void shouldFireEventsOnSavingIterables() {
        List<Actor> actors = Arrays.asList(new Actor("Arnold"), new Actor("Bruce"));
        Iterable iterableActors = actors.stream()::iterator;
        this.session.save(iterableActors);
        EnumSet<Event.TYPE> preAndPostSave = EnumSet.of(Event.TYPE.PRE_SAVE, Event.TYPE.POST_SAVE);
        actors.forEach(actor -> preAndPostSave.forEach(type -> Assertions.assertThat((boolean)eventListener.captured(actor, (Event.TYPE)type))));
    }

    @Test
    public void shouldFireEventsOnDeletingIterables() {
        List<Actor> actors = Arrays.asList(new Actor("Sylvester"), new Actor("Chuck"));
        actors.forEach(arg_0 -> ((Session)this.session).save(arg_0));
        Iterable iterableActors = actors.stream()::iterator;
        this.session.delete(iterableActors);
        EnumSet<Event.TYPE> preAndPostDelete = EnumSet.of(Event.TYPE.PRE_DELETE, Event.TYPE.POST_DELETE);
        actors.forEach(actor -> preAndPostDelete.forEach(type -> Assertions.assertThat((boolean)eventListener.captured(actor, (Event.TYPE)type))));
    }
}

