/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.session.events;

import java.io.Serializable;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.domain.filesystem.Document;
import org.neo4j.ogm.domain.filesystem.FileSystemEntity;
import org.neo4j.ogm.domain.filesystem.Folder;
import org.neo4j.ogm.persistence.session.events.EventTestBaseClass;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.event.Event;
import org.neo4j.ogm.session.event.EventListener;

public class LifecycleTest
extends EventTestBaseClass {
    private EventListener uuidEventListener = new EventListener(){

        public void onPreSave(Event event) {
            FileSystemEntity entity = (FileSystemEntity)event.getObject();
            if (entity.getUuid() == null) {
                entity.setUuid(UUID.randomUUID().toString());
            }
        }

        public void onPostSave(Event event) {
        }

        public void onPreDelete(Event event) {
            FileSystemEntity entity = (FileSystemEntity)event.getObject();
            if (entity instanceof Document) {
                Document d = (Document)entity;
                Folder f = d.getFolder();
                f.setName("updated by pre-delete");
            }
        }

        public void onPostDelete(Event event) {
        }
    };

    @Test
    public void shouldSaveObjectUpdatedByPreSaveEventHandler() {
        this.session.dispose((EventListener)eventListener);
        this.session.register(this.uuidEventListener);
        Folder f = new Folder();
        f.setName("folder");
        Assertions.assertThat((String)f.getUuid()).isNull();
        this.session.save((Object)f);
        Assertions.assertThat((String)f.getUuid()).isNotNull();
        this.session.clear();
        Folder f2 = (Folder)this.session.load(Folder.class, (Serializable)f.getId());
        Assertions.assertThat((String)f2.getName()).isNotNull();
        Assertions.assertThat((String)f2.getUuid()).isNotNull();
    }

    @Test
    public void shouldNotSaveObjectUpdatedByPreDeleteEventHandler() {
        this.session.dispose((EventListener)eventListener);
        this.session.register(this.uuidEventListener);
        Folder f = new Folder();
        Document d = new Document();
        f.setName("folder");
        d.setFolder(f);
        f.getDocuments().add(d);
        Assertions.assertThat((String)f.getUuid()).isNull();
        this.session.save((Object)f);
        Assertions.assertThat((String)f.getUuid()).isNotNull();
        Assertions.assertThat((boolean)((Neo4jSession)this.session).context().isDirty((Object)f)).isFalse();
        this.session.delete((Object)d);
        Assertions.assertThat((String)f.getName()).isEqualTo((Object)"updated by pre-delete");
        Assertions.assertThat((boolean)((Neo4jSession)this.session).context().isDirty((Object)f)).isTrue();
        this.session.clear();
        Folder f2 = (Folder)this.session.load(Folder.class, (Serializable)f.getId());
        Assertions.assertThat((boolean)f2.getDocuments().isEmpty()).isTrue();
        Assertions.assertThat((String)f2.getName()).isEqualTo((Object)"folder");
    }
}

