/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.session.events;

import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.domain.filesystem.Document;
import org.neo4j.ogm.domain.filesystem.Folder;
import org.neo4j.ogm.persistence.session.events.EventTestBaseClass;
import org.neo4j.ogm.session.event.Event;

public class NodeEntityTest
extends EventTestBaseClass {
    @Test
    public void shouldNotFireEventsIfObjectHasNotChanged() {
        this.session.save((Object)this.folder);
        Assertions.assertThat((int)eventListener.count()).isEqualTo(0);
    }

    @Test
    public void shouldNotFireEventsOnLoad() {
        this.session.load(Folder.class, (Serializable)this.folder.getId());
        Assertions.assertThat((int)eventListener.count()).isEqualTo(0);
    }

    @Test
    public void shouldFireEventsWhenCreatingNewEntity() {
        Document e = new Document();
        e.setName("e");
        this.session.save((Object)e);
        Assertions.assertThat((int)eventListener.count()).isEqualTo(2);
        Assertions.assertThat((boolean)eventListener.captured(e, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(e, Event.TYPE.POST_SAVE)).isTrue();
    }

    @Test
    public void shouldFireEventsWhenUpdatingExistingEntity() {
        this.a.setName("newA");
        this.session.save((Object)this.a);
        Assertions.assertThat((int)eventListener.count()).isEqualTo(2);
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.POST_SAVE)).isTrue();
    }

    @Test
    public void shouldFireEventsWhenSettingNullProperty() {
        this.a.setName(null);
        this.session.save((Object)this.a);
        Assertions.assertThat((int)eventListener.count()).isEqualTo(2);
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.a, Event.TYPE.POST_SAVE)).isTrue();
    }

    @Test
    public void shouldNotFireEventsWhenDeletingNonPersistedObject() {
        Document unpersistedDocument = new Document();
        this.session.delete((Object)unpersistedDocument);
        Assertions.assertThat((int)eventListener.count()).isEqualTo(0);
    }

    @Test
    public void shouldFireEventsWhenDeletingRelationshipEntity() {
        this.session.delete((Object)this.knowsJL);
        Assertions.assertThat((boolean)eventListener.captured(this.knowsJL, Event.TYPE.PRE_DELETE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.knowsJL, Event.TYPE.POST_DELETE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.jim, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.jim, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.lee, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.lee, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((int)eventListener.count()).isEqualTo(6);
    }
}

