/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.session.events;

import java.util.Date;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.domain.cineasts.annotated.Knows;
import org.neo4j.ogm.persistence.session.events.EventTestBaseClass;
import org.neo4j.ogm.session.event.Event;

public class RelationshipEntityTest
extends EventTestBaseClass {
    @Test
    public void shouldNotFireEventsIfObjectHasNotChanged() {
        this.session.save((Object)this.folder);
        Assertions.assertThat((int)eventListener.count()).isEqualTo(0);
    }

    @Test
    public void shouldFireEventsWhenUpdatingRelationshipEntity() {
        Random r = new Random();
        this.knowsJL.setSince(new Date((long)(1.293861599E9 + r.nextDouble() * 60.0 * 60.0 * 24.0 * 365.0)));
        this.session.save((Object)this.knowsJL);
        Assertions.assertThat((boolean)eventListener.captured(this.knowsJL, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.knowsJL, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((int)eventListener.count()).isEqualTo(2);
    }

    @Test
    public void shouldFireEventsWhenDeletingRelationshipEntity() {
        this.session.delete((Object)this.knowsJL);
        Assertions.assertThat((boolean)eventListener.captured(this.knowsJL, Event.TYPE.PRE_DELETE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.knowsJL, Event.TYPE.POST_DELETE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.jim, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.jim, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.lee, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.lee, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((int)eventListener.count()).isEqualTo(6);
    }

    @Test
    public void shouldFireEventsWhenCreatingRelationshipEntity() {
        Knows knowsBS = new Knows();
        knowsBS.setFirstActor(this.bruce);
        knowsBS.setSecondActor(this.stan);
        this.bruce.getKnows().add(knowsBS);
        this.session.save((Object)this.bruce);
        Assertions.assertThat((boolean)eventListener.captured(knowsBS, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(knowsBS, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.bruce, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.bruce, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.stan, Event.TYPE.PRE_SAVE)).isTrue();
        Assertions.assertThat((boolean)eventListener.captured(this.stan, Event.TYPE.POST_SAVE)).isTrue();
        Assertions.assertThat((int)eventListener.count()).isEqualTo(6);
    }
}

