/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.session.lifecycle;

import java.io.IOException;
import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.domain.filesystem.Document;
import org.neo4j.ogm.domain.filesystem.Folder;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class StaleObjectTest
extends MultiDriverTestClass {
    private Folder f;
    private Document a;
    private Document b;
    private Session session;

    @Before
    public void init() throws IOException {
        SessionFactory sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.filesystem"});
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
        this.a = new Document();
        this.a.setName("a");
        this.b = new Document();
        this.b.setName("b");
        this.f = new Folder();
        this.f.setName("f");
        this.f.getDocuments().add(this.a);
        this.f.getDocuments().add(this.b);
        this.a.setFolder(this.f);
        this.b.setFolder(this.f);
        this.session.save((Object)this.f);
        Assertions.assertThat((String)this.a.toString()).isEqualTo((Object)"Document{folder=Folder{name='f', documents=2, archived=0}, name='a'}");
        Assertions.assertThat((String)this.b.toString()).isEqualTo((Object)"Document{folder=Folder{name='f', documents=2, archived=0}, name='b'}");
    }

    @Test
    public void testSaveDegenerateDocument() {
        this.a.setFolder(null);
        this.session.save((Object)this.a);
        Folder p = (Folder)this.session.load(Folder.class, (Serializable)this.f.getId());
        Assertions.assertThat((String)p.toString()).isEqualTo((Object)"Folder{name='f', documents=1, archived=0}");
        Assertions.assertThat((p.getDocuments().iterator().next() == this.b ? 1 : 0) != 0).isFalse();
        Assertions.assertThat((String)this.a.toString()).isEqualTo((Object)"Document{folder=null, name='a'}");
        Assertions.assertThat((String)this.b.toString()).isEqualTo((Object)"Document{folder=Folder{name='f', documents=2, archived=0}, name='b'}");
        Assertions.assertThat((String)p.getDocuments().iterator().next().toString()).isEqualTo((Object)"Document{folder=Folder{name='f', documents=1, archived=0}, name='b'}");
    }

    @Test
    public void testSaveDegenerateFolder() {
        this.f.getDocuments().clear();
        this.session.save((Object)this.f);
        Assertions.assertThat((String)this.f.toString()).isEqualTo((Object)"Folder{name='f', documents=0, archived=0}");
        Assertions.assertThat((String)this.a.toString()).isEqualTo((Object)"Document{folder=Folder{name='f', documents=0, archived=0}, name='a'}");
        Assertions.assertThat((String)this.b.toString()).isEqualTo((Object)"Document{folder=Folder{name='f', documents=0, archived=0}, name='b'}");
        Document aa = (Document)this.session.load(Document.class, (Serializable)this.a.getId());
        Document bb = (Document)this.session.load(Document.class, (Serializable)this.b.getId());
        Assertions.assertThat((String)aa.toString()).isEqualTo((Object)"Document{folder=null, name='a'}");
        Assertions.assertThat((String)bb.toString()).isEqualTo((Object)"Document{folder=null, name='b'}");
    }
}

