/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.transaction;

import java.lang.reflect.Field;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.exception.TransactionException;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.transaction.DefaultTransactionManager;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.neo4j.ogm.transaction.AbstractTransaction;
import org.neo4j.ogm.transaction.Transaction;
import org.neo4j.ogm.transaction.TransactionManager;

public class ClosedTransactionTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private DefaultTransactionManager transactionManager;
    private Transaction tx;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.tree"});
    }

    @Before
    public void init() {
        Session session = sessionFactory.openSession();
        this.transactionManager = new DefaultTransactionManager(session, driver.getTransactionFactorySupplier());
    }

    @Before
    public void createTransactionAndCloseOnServerButNotOnClient() {
        this.tx = this.transactionManager.openTransaction();
        this.tx.close();
        ClosedTransactionTest.reOpen((TransactionManager)this.transactionManager, this.tx);
    }

    @After
    public void clearTransactionManager() {
        ClosedTransactionTest.getTransactionThreadLocal((TransactionManager)this.transactionManager).remove();
    }

    @Test
    public void shouldNotThrowExceptionWhenRollingBackAClosedTransaction() {
        this.tx.rollback();
    }

    @Test
    public void shouldNotThrowExceptionWhenClosingAClosedTransaction() {
        this.tx.close();
    }

    @Test(expected=TransactionException.class)
    public void shouldThrowExceptionWhenCommittingAClosedTransaction() {
        this.tx.commit();
    }

    private static void reOpen(TransactionManager transactionManager, Transaction transaction) {
        try {
            Field statusField = AbstractTransaction.class.getDeclaredField("status");
            statusField.setAccessible(true);
            statusField.set(transaction, Transaction.Status.OPEN);
            ClosedTransactionTest.getTransactionThreadLocal(transactionManager).set(transaction);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ThreadLocal<Transaction> getTransactionThreadLocal(TransactionManager transactionManager) {
        try {
            Field transactionField = DefaultTransactionManager.class.getDeclaredField("currentThreadLocalTransaction");
            transactionField.setAccessible(true);
            return (ThreadLocal)transactionField.get(transactionManager);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

