/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.types.convertible;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.domain.convertible.date.Java8DatesMemo;
import org.neo4j.ogm.domain.convertible.date.Memo;
import org.neo4j.ogm.domain.convertible.enums.Education;
import org.neo4j.ogm.domain.convertible.enums.Gender;
import org.neo4j.ogm.domain.convertible.enums.Person;
import org.neo4j.ogm.domain.convertible.numbers.Account;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class ConvertibleIntegrationTest
extends MultiDriverTestClass {
    private static Session session;

    @BeforeClass
    public static void init() throws IOException {
        session = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.convertible"}).openSession();
    }

    @After
    public void teardown() {
        session.purgeDatabase();
    }

    @Test
    public void shouldSaveAndRetrieveEnums() {
        ArrayList<Education> completed = new ArrayList<Education>();
        completed.add(Education.HIGHSCHOOL);
        completed.add(Education.BACHELORS);
        Person person = new Person();
        person.setName("luanne");
        person.setInProgressEducation(new Education[]{Education.MASTERS, Education.PHD});
        person.setCompletedEducation(completed);
        person.setGender(Gender.FEMALE);
        session.save((Object)person);
        Person luanne = (Person)session.loadAll(Person.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"luanne")).iterator().next();
        Assertions.assertThat((Comparable)((Object)luanne.getGender())).isEqualTo((Object)Gender.FEMALE);
        Assertions.assertThat((boolean)luanne.getCompletedEducation().contains((Object)Education.HIGHSCHOOL)).isTrue();
        Assertions.assertThat((boolean)luanne.getCompletedEducation().contains((Object)Education.BACHELORS)).isTrue();
        Assertions.assertThat((int)luanne.getInProgressEducation().length).isEqualTo(2);
        Assertions.assertThat((luanne.getInProgressEducation()[0].equals((Object)Education.MASTERS) || luanne.getInProgressEducation()[1].equals((Object)Education.MASTERS) ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((luanne.getInProgressEducation()[0].equals((Object)Education.PHD) || luanne.getInProgressEducation()[1].equals((Object)Education.PHD) ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void shouldSaveAndRetrieveEnumsAsResult() {
        ArrayList<Education> completed = new ArrayList<Education>();
        completed.add(Education.HIGHSCHOOL);
        completed.add(Education.BACHELORS);
        Person person = new Person();
        person.setName("luanne");
        person.setInProgressEducation(new Education[]{Education.MASTERS, Education.PHD});
        person.setCompletedEducation(completed);
        person.setGender(Gender.FEMALE);
        session.save((Object)person);
        session.clear();
        Result res = session.query("MATCH (p:Person{name:'luanne'}) return p", Collections.EMPTY_MAP);
        Person luanne = (Person)((Map)((Iterable)res.queryResults()).iterator().next()).get("p");
        Assertions.assertThat((Comparable)((Object)luanne.getGender())).isEqualTo((Object)Gender.FEMALE);
        Assertions.assertThat((boolean)luanne.getCompletedEducation().contains((Object)Education.HIGHSCHOOL)).isTrue();
        Assertions.assertThat((boolean)luanne.getCompletedEducation().contains((Object)Education.BACHELORS)).isTrue();
        Assertions.assertThat((int)luanne.getInProgressEducation().length).isEqualTo(2);
        Assertions.assertThat((luanne.getInProgressEducation()[0].equals((Object)Education.MASTERS) || luanne.getInProgressEducation()[1].equals((Object)Education.MASTERS) ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((luanne.getInProgressEducation()[0].equals((Object)Education.PHD) || luanne.getInProgressEducation()[1].equals((Object)Education.PHD) ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void shouldSaveAndRetrieveDates() {
        SimpleDateFormat simpleDateISO8601format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        simpleDateISO8601format.setTimeZone(TimeZone.getTimeZone("UTC"));
        GregorianCalendar date0 = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        date0.setTimeInMillis(0L);
        GregorianCalendar date20000 = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        date20000.setTimeInMillis(20000L);
        HashSet<Date> implementations = new HashSet<Date>();
        implementations.add(date0.getTime());
        implementations.add(date20000.getTime());
        GregorianCalendar date40000 = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        date40000.setTimeInMillis(40000L);
        GregorianCalendar date100000 = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        date100000.setTimeInMillis(100000L);
        Date[] escalations = new Date[]{date40000.getTime(), date100000.getTime()};
        GregorianCalendar actioned = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        actioned.setTimeInMillis(20000L);
        Memo memo = new Memo();
        memo.setMemo("theMemo");
        memo.setImplementations(implementations);
        memo.setEscalations(escalations);
        memo.setActioned(actioned.getTime());
        memo.setClosed(new Date());
        memo.setActionedAsInstant(actioned.toInstant());
        session.save((Object)memo);
        Memo loadedMemo = (Memo)session.loadAll(Memo.class, new Filter("memo", ComparisonOperator.EQUALS, (Object)"theMemo")).iterator().next();
        GregorianCalendar loadedCal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        loadedCal.setTime(loadedMemo.getActioned());
        Assertions.assertThat((int)loadedCal.get(5)).isEqualTo(actioned.get(5));
        Assertions.assertThat((int)loadedCal.get(2)).isEqualTo(actioned.get(2));
        Assertions.assertThat((int)loadedCal.get(1)).isEqualTo(actioned.get(1));
        Assertions.assertThat((Instant)loadedMemo.getActionedAsInstant()).isEqualTo((Object)actioned.toInstant());
        Assertions.assertThat(loadedMemo.getImplementations()).hasSize(2);
        Iterator<Date> implementationsIter = loadedMemo.getImplementations().iterator();
        loadedCal.setTime(implementationsIter.next());
        Assertions.assertThat((int)loadedCal.get(5)).isEqualTo(date0.get(5));
        Assertions.assertThat((int)loadedCal.get(2)).isEqualTo(date0.get(2));
        Assertions.assertThat((int)loadedCal.get(1)).isEqualTo(date0.get(1));
        loadedCal.setTime(implementationsIter.next());
        Assertions.assertThat((int)loadedCal.get(5)).isEqualTo(date20000.get(5));
        Assertions.assertThat((int)loadedCal.get(2)).isEqualTo(date20000.get(2));
        Assertions.assertThat((int)loadedCal.get(1)).isEqualTo(date20000.get(1));
        Assertions.assertThat((int)loadedMemo.getEscalations().length).isEqualTo(2);
        loadedCal.setTime(loadedMemo.getEscalations()[0]);
        Assertions.assertThat((int)loadedCal.get(5)).isEqualTo(date40000.get(5));
        Assertions.assertThat((int)loadedCal.get(2)).isEqualTo(date40000.get(2));
        Assertions.assertThat((int)loadedCal.get(1)).isEqualTo(date40000.get(1));
        loadedCal.setTime(loadedMemo.getEscalations()[1]);
        Assertions.assertThat((int)loadedCal.get(5)).isEqualTo(date100000.get(5));
        Assertions.assertThat((int)loadedCal.get(2)).isEqualTo(date100000.get(2));
        Assertions.assertThat((int)loadedCal.get(1)).isEqualTo(date100000.get(1));
    }

    @Test
    public void shouldSaveAndRetrieveJava8Dates() {
        Instant instant = Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse("2007-12-03T10:15:30.001+01:00"));
        Java8DatesMemo java8DatesMemo = new Java8DatesMemo(instant);
        session.save((Object)java8DatesMemo);
        session.clear();
        Result result = session.query("MATCH (m:Java8DatesMemo) return m.recorded, m.closed, m.approved", Collections.emptyMap());
        Map record = (Map)((Iterable)result.queryResults()).iterator().next();
        Assertions.assertThat(record.get("m.recorded")).isEqualTo((Object)"2007-12-03T09:15:30.001Z");
        Assertions.assertThat(record.get("m.closed")).isEqualTo((Object)1196673330001L);
        Assertions.assertThat(record.get("m.approved")).isEqualTo((Object)"2007-12-03");
        Java8DatesMemo memo = (Java8DatesMemo)session.loadAll(Java8DatesMemo.class).iterator().next();
        Assertions.assertThat((Instant)memo.getRecorded()).isEqualTo((Object)instant);
        Assertions.assertThat((Instant)memo.getClosed()).isEqualTo((Object)instant);
        Assertions.assertThat((LocalDate)memo.getApproved()).isEqualTo((Object)LocalDateTime.ofInstant(instant, ZoneOffset.UTC).toLocalDate());
    }

    @Test
    public void shouldSaveListOfLocalDate() throws Exception {
        Java8DatesMemo memo = new Java8DatesMemo();
        LocalDate now = LocalDate.of(2017, 7, 23);
        LocalDate tomorrow = now.plusDays(1L);
        List<LocalDate> dateList = Arrays.asList(now, tomorrow);
        memo.setDateList(dateList);
        session.save((Object)memo);
        session.clear();
        Result result = session.query("MATCH (m:Java8DatesMemo) return m.dateList", Collections.emptyMap());
        Map record = (Map)((Iterable)result.queryResults()).iterator().next();
        Object[] dateArray = (String[])record.get("m.dateList");
        Assertions.assertThat((Object[])dateArray).isEqualTo((Object)new String[]{"2017-07-23", "2017-07-24"});
        Java8DatesMemo loaded = (Java8DatesMemo)session.load(Java8DatesMemo.class, (Serializable)memo.getId());
        Assertions.assertThat(loaded.getDateList()).isEqualTo(dateList);
    }

    @Test
    public void shouldSaveLocalDateTime() throws Exception {
        Java8DatesMemo memo = new Java8DatesMemo();
        LocalDateTime dateTime = LocalDateTime.of(2017, 7, 23, 1, 2, 3);
        memo.setDateTime(dateTime);
        session.save((Object)memo);
        session.clear();
        Result result = session.query("MATCH (m:Java8DatesMemo) return m.dateTime", Collections.emptyMap());
        Map record = (Map)((Iterable)result.queryResults()).iterator().next();
        Assertions.assertThat(record.get("m.dateTime")).isEqualTo((Object)"2017-07-23T01:02:03");
        Java8DatesMemo loaded = (Java8DatesMemo)session.load(Java8DatesMemo.class, (Serializable)memo.getId());
        Assertions.assertThat((LocalDateTime)loaded.getDateTime()).isEqualTo((Object)dateTime);
    }

    @Test
    public void shouldSaveListOfLocalDateTime() throws Exception {
        Java8DatesMemo memo = new Java8DatesMemo();
        LocalDateTime dateTime = LocalDateTime.of(2017, 7, 23, 1, 2, 3);
        LocalDateTime dateTime1 = dateTime.plusDays(1L);
        List<LocalDateTime> dateTimeList = Arrays.asList(dateTime, dateTime1);
        memo.setDateTimeList(dateTimeList);
        session.save((Object)memo);
        session.clear();
        Result result = session.query("MATCH (m:Java8DatesMemo) return m.dateTimeList", Collections.emptyMap());
        Map record = (Map)((Iterable)result.queryResults()).iterator().next();
        Object[] dateArray = (String[])record.get("m.dateTimeList");
        Assertions.assertThat((Object[])dateArray).isEqualTo((Object)new String[]{"2017-07-23T01:02:03", "2017-07-24T01:02:03"});
        Java8DatesMemo loaded = (Java8DatesMemo)session.load(Java8DatesMemo.class, (Serializable)memo.getId());
        Assertions.assertThat(loaded.getDateTimeList()).isEqualTo(dateTimeList);
    }

    @Test
    public void shouldSaveOffsetDateTime() throws Exception {
        Java8DatesMemo memo = new Java8DatesMemo();
        LocalDateTime dateTime = LocalDateTime.of(2017, 7, 23, 1, 2, 3);
        OffsetDateTime offsetDateTime = OffsetDateTime.of(dateTime, ZoneOffset.ofHours(1));
        memo.setOffsetDateTime(offsetDateTime);
        session.save((Object)memo);
        session.clear();
        Result result = session.query("MATCH (m:Java8DatesMemo) return m.offsetDateTime", Collections.emptyMap());
        Map record = (Map)((Iterable)result.queryResults()).iterator().next();
        Assertions.assertThat(record.get("m.offsetDateTime")).isEqualTo((Object)"2017-07-23T01:02:03+01:00");
        Java8DatesMemo loaded = (Java8DatesMemo)session.load(Java8DatesMemo.class, (Serializable)memo.getId());
        Assertions.assertThat((OffsetDateTime)loaded.getOffsetDateTime()).isEqualTo((Object)offsetDateTime);
    }

    @Test
    public void shouldSaveOffsetDateTimeList() throws Exception {
        Java8DatesMemo memo = new Java8DatesMemo();
        LocalDateTime dateTime = LocalDateTime.of(2017, 7, 23, 1, 2, 3);
        OffsetDateTime offsetDateTime = OffsetDateTime.of(dateTime, ZoneOffset.ofHours(1));
        OffsetDateTime offsetDateTime1 = OffsetDateTime.of(dateTime.plusDays(1L), ZoneOffset.ofHours(1));
        List<OffsetDateTime> offsetDateTimeList = Arrays.asList(offsetDateTime, offsetDateTime1);
        memo.setOffsetDateTimeList(offsetDateTimeList);
        session.save((Object)memo);
        session.clear();
        Result result = session.query("MATCH (m:Java8DatesMemo) return m.offsetDateTimeList", Collections.emptyMap());
        Map record = (Map)((Iterable)result.queryResults()).iterator().next();
        Object[] dateArray = (String[])record.get("m.offsetDateTimeList");
        Assertions.assertThat((Object[])dateArray).isEqualTo((Object)new String[]{"2017-07-23T01:02:03+01:00", "2017-07-24T01:02:03+01:00"});
        Java8DatesMemo loaded = (Java8DatesMemo)session.load(Java8DatesMemo.class, (Serializable)memo.getId());
        Assertions.assertThat(loaded.getOffsetDateTimeList()).isEqualTo(offsetDateTimeList);
    }

    @Test
    public void shouldSaveAndRetrieveNumbers() {
        Account account = new Account(new BigDecimal("12345.67"), new BigInteger("1000"));
        account.setCode((short)1000);
        BigDecimal[] deposits = new BigDecimal[]{new BigDecimal("12345.67"), new BigDecimal("34567.89")};
        ArrayList<BigInteger> loans = new ArrayList<BigInteger>();
        loans.add(BigInteger.valueOf(123456L));
        loans.add(BigInteger.valueOf(567890L));
        account.setLoans(loans);
        account.setDeposits(deposits);
        session.save((Object)account);
        Account loadedAccount = (Account)session.loadAll(Account.class).iterator().next();
        Assertions.assertThat((short)account.getCode()).isEqualTo((short)1000);
        Assertions.assertThat((BigDecimal)loadedAccount.getBalance()).isEqualTo((Object)new BigDecimal("12345.67"));
        Assertions.assertThat((BigInteger)loadedAccount.getFacility()).isEqualTo((Object)new BigInteger("1000"));
        Assertions.assertThat(loadedAccount.getLoans()).isEqualTo(loans);
        Assertions.assertThat((Object[])loadedAccount.getDeposits()).isEqualTo((Object)deposits);
    }

    @Test
    public void shouldSaveAndRetrieveIntegerDates() {
        Memo memo = new Memo();
        memo.setClosed(new Date(0L));
        session.save((Object)memo);
        memo = (Memo)session.load(Memo.class, (Serializable)memo.getId());
        Assertions.assertThat((long)memo.getClosed().getTime()).isEqualTo(new Date(0L).getTime());
    }

    @Test
    public void shouldSaveAndRetrieveIntegerFloats() {
        Account account = new Account();
        account.setLimit(Float.valueOf(10.0f));
        session.save((Object)account);
        Account loadedAccount = (Account)session.load(Account.class, (Serializable)account.getId());
        Assertions.assertThat((Float)loadedAccount.getLimit()).isEqualTo((Object)account.getLimit());
        account.setLimit(Float.valueOf(18277.55f));
        session.save((Object)account);
        loadedAccount = (Account)session.load(Account.class, (Serializable)account.getId());
        Assertions.assertThat((Float)loadedAccount.getLimit()).isEqualTo((Object)account.getLimit());
    }

    public void assertSameArray(Object[] as, Object[] bs) {
        if (as == null || bs == null) {
            Assertions.fail((String)"null arrays not allowed");
        }
        if (as.length != bs.length) {
            Assertions.fail((String)"arrays are not same length");
        }
        for (Object a : as) {
            boolean found = false;
            for (Object b : bs) {
                if (!b.toString().equals(a.toString())) continue;
                found = true;
                break;
            }
            if (found) continue;
            Assertions.fail((String)("array contents are not the same: " + as + ", " + bs));
        }
    }
}

