/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.types.properties;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.ogm.domain.properties.SomeNode;
import org.neo4j.ogm.domain.properties.User;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class PropertiesTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;
    @Rule
    public ExpectedException thrownException = ExpectedException.none();

    @BeforeClass
    public static void init() {
        sessionFactory = new SessionFactory(driver, new String[]{User.class.getName(), SomeNode.class.getName()});
    }

    @Before
    public void setUp() {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void shouldHandleEnumsAsKey() {
        User user = new User("A");
        user.setEnumAProperties(Collections.singletonMap(User.EnumA.VALUE_AA, "aa"));
        user.setEnumBProperties(Collections.singletonMap(User.EnumB.VALUE_BA, "ba"));
        this.session.save((Object)user);
        this.session.clear();
        user = (User)this.session.load(User.class, (Serializable)user.getId());
        Assertions.assertThat(user.getEnumAProperties()).containsEntry((Object)User.EnumA.VALUE_AA, (Object)"aa");
        Assertions.assertThat(user.getEnumBProperties()).containsEntry((Object)User.EnumB.VALUE_BA, (Object)"ba");
        try (Transaction tx = PropertiesTest.getGraphDatabaseService().beginTx();){
            Node userNode = PropertiesTest.getGraphDatabaseService().getNodeById(user.getId().longValue());
            Assertions.assertThat((Map)userNode.getAllProperties()).containsKeys((Object[])new String[0]).containsKeys((Object[])new String[]{"enumAProperties.VALUE_AA", "enumBProperties.VALUE_BA"});
            tx.success();
        }
    }

    @Test
    public void shouldNotAllowNullKeys() {
        this.thrownException.expect(UnsupportedOperationException.class);
        this.thrownException.expectMessage("Null is not a supported property key!");
        User user = new User("A");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(null, "irrelevant");
        user.setMyProperties(properties);
        this.session.save((Object)user);
        this.session.clear();
    }

    @Test
    public void shouldNotAllowKeysOtherThanStringAndEnum() {
        this.thrownException.expect(UnsupportedOperationException.class);
        this.thrownException.expectMessage("Only String and Enum allowed to be keys, got class java.lang.Integer");
        User user = new User("A");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put((String)((Object)Integer.valueOf(123)), "irrelevant");
        user.setMyProperties(properties);
        this.session.save((Object)user);
        this.session.clear();
    }

    @Test
    public void shouldMapPropertiesAttributeToNodeProperties() {
        User user = new User("Frantisek");
        user.putMyProperty("city", "London");
        user.putMyProperty("zipCode", "SW1A 1AA");
        this.session.save((Object)user);
        try (Transaction tx = PropertiesTest.getGraphDatabaseService().beginTx();){
            Node userNode = PropertiesTest.getGraphDatabaseService().getNodeById(user.getId().longValue());
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)userNode.getAllProperties()).hasSize(3)).containsEntry((Object)"name", (Object)"Frantisek")).containsEntry((Object)"myProperties.city", (Object)"London")).containsEntry((Object)"myProperties.zipCode", (Object)"SW1A 1AA");
            tx.success();
        }
    }

    @Test
    public void shouldMapPropertiesAttributeWithNestedMapToNodeProperties() {
        User user = new User("Frantisek");
        HashMap<String, String> address = new HashMap<String, String>();
        address.put("city", "London");
        address.put("zipCode", "SW1A 1AA");
        user.putMyProperty("address", address);
        this.session.save((Object)user);
        try (Transaction tx = PropertiesTest.getGraphDatabaseService().beginTx();){
            Node userNode = PropertiesTest.getGraphDatabaseService().getNodeById(user.getId().longValue());
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)userNode.getAllProperties()).hasSize(3)).containsEntry((Object)"name", (Object)"Frantisek")).containsEntry((Object)"myProperties.address.city", (Object)"London")).containsEntry((Object)"myProperties.address.zipCode", (Object)"SW1A 1AA");
            tx.success();
        }
    }

    @Test
    public void shouldMapPropertiesAttributeWithPrefixToNodeProperties() {
        User user = new User("Frantisek");
        user.putPrefixedProperty("city", "London");
        user.putPrefixedProperty("zipCode", "SW1A 1AA");
        this.session.save((Object)user);
        try (Transaction tx = PropertiesTest.getGraphDatabaseService().beginTx();){
            Node userNode = PropertiesTest.getGraphDatabaseService().getNodeById(user.getId().longValue());
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)userNode.getAllProperties()).hasSize(3)).containsEntry((Object)"name", (Object)"Frantisek")).containsEntry((Object)"myPrefix.city", (Object)"London")).containsEntry((Object)"myPrefix.zipCode", (Object)"SW1A 1AA");
            tx.success();
        }
    }

    @Test
    public void shouldMapPropertiesAttributeWithDelimiterToNodeProperties() {
        User user = new User("Frantisek");
        user.putDelimiterProperty("city", "London");
        user.putDelimiterProperty("zipCode", "SW1A 1AA");
        this.session.save((Object)user);
        try (Transaction tx = PropertiesTest.getGraphDatabaseService().beginTx();){
            Node userNode = PropertiesTest.getGraphDatabaseService().getNodeById(user.getId().longValue());
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)userNode.getAllProperties()).hasSize(3)).containsEntry((Object)"name", (Object)"Frantisek")).containsEntry((Object)"delimiterProperties__city", (Object)"London")).containsEntry((Object)"delimiterProperties__zipCode", (Object)"SW1A 1AA");
            tx.success();
        }
    }

    @Test
    public void shouldMapNodePropertiesToPropertiesAttribute() {
        this.session.query("CREATE (u:User {`name`:'Frantisek', `myProperties.city`:'London', `myProperties.zipCode`:'SW1A 1AA'})", Collections.emptyMap());
        User user = (User)this.session.loadAll(User.class).iterator().next();
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat(user.getMyProperties()).hasSize(2)).doesNotContainKey((Object)"name")).containsEntry((Object)"city", (Object)"London")).containsEntry((Object)"zipCode", (Object)"SW1A 1AA");
    }

    @Test
    public void shouldMapNestedNodePropertiesToPropertiesAttributeAsNestedMap() {
        this.session.query("CREATE (u:User {`name`:'Frantisek', `myProperties.address.city`:'London', `myProperties.address.zipCode`:'SW1A 1AA'})", Collections.emptyMap());
        User user = (User)this.session.loadAll(User.class).iterator().next();
        Map address = (Map)user.getMyProperties().get("address");
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)address).hasSize(2)).containsEntry((Object)"city", (Object)"London")).containsEntry((Object)"zipCode", (Object)"SW1A 1AA");
    }

    @Test
    public void shouldMapNodePropertiesToPropertiesAttributeWithPrefix() {
        this.session.query("CREATE (u:User {`name`:'Frantisek', `myPrefix.city`:'London', `myPrefix.zipCode`:'SW1A 1AA'})", Collections.emptyMap());
        User user = (User)this.session.loadAll(User.class).iterator().next();
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat(user.getPrefixedProperties()).hasSize(2)).doesNotContainKey((Object)"name")).containsEntry((Object)"city", (Object)"London")).containsEntry((Object)"zipCode", (Object)"SW1A 1AA");
    }

    @Test
    public void shouldMapNodePropertiesToPropertiesAttributeWithDelimiter() {
        this.session.query("CREATE (u:User {`name`:'Frantisek', `delimiterProperties__city`:'London', `delimiterProperties__zipCode`:'SW1A 1AA'})", Collections.emptyMap());
        User user = (User)this.session.loadAll(User.class).iterator().next();
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat(user.getDelimiterProperties()).hasSize(2)).doesNotContainKey((Object)"name")).containsEntry((Object)"city", (Object)"London")).containsEntry((Object)"zipCode", (Object)"SW1A 1AA");
    }

    @Test
    public void shouldSaveAndLoadMapOfAllPropertyTypes() {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        propertyMap.put("Long", 5L);
        propertyMap.put("Double", 7.0);
        propertyMap.put("Boolean", true);
        propertyMap.put("String", "String");
        propertyMap.put("Long[]", Arrays.asList(5L, 6L, 7L));
        propertyMap.put("Double[]", Arrays.asList(7.0, 8.0, 9.0));
        propertyMap.put("Boolean[]", Arrays.asList(true, false, true));
        propertyMap.put("String[]", Arrays.asList("S", "t", "r", "i", "n", "g"));
        User user = new User();
        user.setMyProperties(propertyMap);
        this.session.save((Object)user);
        this.session.clear();
        User loaded = (User)this.session.load(User.class, (Serializable)user.getId());
        Assertions.assertThat(loaded.getMyProperties()).isEqualTo(propertyMap);
    }

    @Test(expected=MappingException.class)
    public void shouldThrowExceptionWhenMappingNonCypherType() {
        User user = new User();
        user.putMyProperty("age", 18);
        this.session.save((Object)user);
    }

    @Test(expected=MappingException.class)
    public void shouldThrowExceptionWhenMappingNonConvertibleType() {
        User user = new User();
        user.putAllowCastProperty("age", new Date());
        this.session.save((Object)user);
    }

    @Test
    public void shouldMapSpecificValueType() {
        User user = new User();
        user.putIntegerProperty("age", 18);
        this.session.save((Object)user);
        this.session.clear();
        User loaded = (User)this.session.load(User.class, (Serializable)user.getId());
        Assertions.assertThat(loaded.getIntegerProperties()).containsEntry((Object)"age", (Object)18);
    }

    @Test
    public void shouldConvertNestedMapWithList() {
        HashMap<String, List<Integer>> nested = new HashMap<String, List<Integer>>();
        nested.put("value", Arrays.asList(1, 2, 3, 4));
        User user = new User();
        user.putMyProperty("nested", nested);
        this.session.save((Object)user);
        this.session.clear();
        User loaded = (User)this.session.load(User.class, (Serializable)user.getId());
        Assertions.assertThat(loaded.getMyProperties()).isEqualTo(loaded.getMyProperties());
    }

    @Test
    public void shouldBeAbleToDeletePropertiesAgain() {
        User user = new User();
        user.putMyProperty("prop1", "A property");
        user.putMyProperty("prop2", "Another property");
        user.putIntegerProperty("anInt", 1);
        user.putIntegerProperty("anotherInt", 2);
        user.putDelimiterProperty("a", "b");
        this.session.save((Object)user);
        this.session.clear();
        User loaded = (User)this.session.load(User.class, (Serializable)user.getId());
        Assertions.assertThat(loaded.getMyProperties()).containsKeys((Object[])new String[]{"prop1", "prop2"});
        Assertions.assertThat(loaded.getIntegerProperties()).hasSize(2);
        Assertions.assertThat(loaded.getDelimiterProperties()).hasSize(1);
        Assertions.assertThat(loaded.getPrefixedProperties()).isEmpty();
        loaded.getMyProperties().remove("prop1");
        loaded.getIntegerProperties().clear();
        loaded.setDelimiterProperties(null);
        this.session.save((Object)loaded);
        this.session.clear();
        loaded = (User)this.session.load(User.class, (Serializable)user.getId());
        Assertions.assertThat(loaded.getMyProperties()).containsKeys((Object[])new String[]{"prop2"});
        Assertions.assertThat(loaded.getIntegerProperties()).isEmpty();
        Assertions.assertThat(loaded.getDelimiterProperties()).isEmpty();
        Assertions.assertThat(loaded.getPrefixedProperties()).isEmpty();
    }

    @Test
    public void shouldNotDeleteUnmappedProperties() {
        this.session.query("CREATE (u:SomeNode {`name`:'Unmapped', `myPrefix.aProperty`:'aValue'})", Collections.emptyMap());
        SomeNode someNode = (SomeNode)this.session.loadAll(SomeNode.class).iterator().next();
        ((MapAssert)Assertions.assertThat(someNode.getPrefixedProperties()).hasSize(1)).containsEntry((Object)"aProperty", (Object)"aValue");
        someNode.getPrefixedProperties().remove("aProperty");
        someNode.getPrefixedProperties().put("anotherProperty", "anotherValue");
        this.session.save((Object)someNode);
        this.session.clear();
        Iterator result = this.session.query("MATCH (u:SomeNode) WHERE id(u) = $id RETURN u.name as name, u.`myPrefix.anotherProperty` as anotherProperty", Collections.singletonMap("id", someNode.getId())).iterator();
        Assertions.assertThat((boolean)result.hasNext()).isTrue();
        result.forEachRemaining(m -> {
            MapAssert cfr_ignored_0 = (MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)m).hasSize(2)).containsEntry((Object)"name", (Object)"Unmapped")).containsEntry((Object)"anotherProperty", (Object)"anotherValue");
        });
    }
}

