/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session;

import java.util.Arrays;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.transaction.Transaction;

@RunWith(value=MockitoJUnitRunner.class)
public class BookmarkTest {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private org.neo4j.driver.v1.Driver nativeDriver;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private org.neo4j.driver.v1.Session nativeSession;
    private Session session;

    @Before
    public void setUp() throws Exception {
        BoltDriver driver = new BoltDriver(this.nativeDriver);
        this.session = new Neo4jSession(new MetaData(new String[]{"org.neo4j.ogm.empty"}), true, (Driver)driver);
        Mockito.when((Object)this.nativeDriver.session((AccessMode)ArgumentMatchers.any(AccessMode.class), ArgumentMatchers.anyIterable())).thenReturn((Object)this.nativeSession);
        Mockito.when((Object)this.nativeSession.beginTransaction().isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.nativeSession.lastBookmark()).thenReturn((Object)"last-bookmark");
    }

    @Test
    public void shouldPassBookmarksToDriver() throws Exception {
        HashSet<String> bookmarks = new HashSet<String>(Arrays.asList("bookmark1", "bookmark2"));
        Transaction transaction = this.session.beginTransaction(Transaction.Type.READ_ONLY, bookmarks);
        ((org.neo4j.driver.v1.Driver)Mockito.verify((Object)this.nativeDriver)).session(AccessMode.READ, bookmarks);
        transaction.rollback();
        transaction.close();
    }

    @Test
    public void shouldHaveAvailableBookmark() throws Exception {
        Transaction transaction = this.session.beginTransaction(Transaction.Type.READ_WRITE);
        transaction.commit();
        transaction.close();
        String lastBookmark = this.session.getLastBookmark();
        Assertions.assertThat((String)lastBookmark).isEqualTo((Object)"last-bookmark");
    }
}

