/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.session.SessionFactory;

public class SessionFactoryTest {
    @Test
    public void correctUseStrictQueryingSettingShouldBeApplied() {
        SessionFactory sessionFactory = new SessionFactory(new Configuration.Builder().uri("bolt://something:7687").build(), new String[]{"org.neo4j.ogm.domain.gh651"});
        Assertions.assertThat((boolean)sessionFactory.isUseStrictQuerying()).isFalse();
        sessionFactory = new SessionFactory(new Configuration.Builder().uri("bolt://something:7687").strictQuerying().build(), new String[]{"org.neo4j.ogm.domain.gh651"});
        Assertions.assertThat((boolean)sessionFactory.isUseStrictQuerying()).isTrue();
        Driver mockedDriver = (Driver)Mockito.mock(Driver.class);
        sessionFactory = new SessionFactory(mockedDriver, new String[]{"org.neo4j.ogm.domain.gh651"});
        Assertions.assertThat((boolean)sessionFactory.isUseStrictQuerying()).isFalse();
        sessionFactory = new SessionFactory(mockedDriver, true, new String[]{"org.neo4j.ogm.domain.gh651"});
        Assertions.assertThat((boolean)sessionFactory.isUseStrictQuerying()).isTrue();
    }
}

