/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.PagingAndSortingQuery;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.session.request.strategy.QueryStatements;
import org.neo4j.ogm.session.request.strategy.impl.RelationshipQueryStatements;

public class RelationshipEntityQuerySortingTest {
    private final QueryStatements query = new RelationshipQueryStatements();
    private SortOrder sortOrder;
    private Filters filters;

    @Before
    public void setUp() {
        this.sortOrder = new SortOrder();
        this.filters = new Filters();
    }

    @Test
    public void testFindByLabel() {
        this.sortOrder.add(new String[]{"distance"});
        String statement = this.query.findByType("ORBITS", 3).setSortOrder(this.sortOrder).getStatement();
        String expected = "MATCH ()-[r0:`ORBITS`]-()  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m ORDER BY r0.distance MATCH p1 = (n)-[*0..3]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..3]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)";
        Assertions.assertThat((String)statement).isEqualTo((Object)expected);
    }

    @Test
    public void testFindByProperty() {
        this.filters.add(new Filter("distance", ComparisonOperator.EQUALS, (Object)60.2));
        this.sortOrder.add(new String[]{"aphelion"});
        String expected = "MATCH (n)-[r0:`ORBITS`]->(m) WHERE r0.`distance` = { `distance_0` }  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m ORDER BY r0.aphelion MATCH p1 = (n)-[*0..1]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..1]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)";
        Assertions.assertThat((String)this.query.findByType("ORBITS", this.filters, 1).setSortOrder(this.sortOrder).getStatement()).isEqualTo((Object)expected);
    }

    @Test
    public void testMultipleSortOrders() {
        String cypher = "MATCH ()-[r0:`ORBITS`]-()  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m ORDER BY r0.distance DESC,r0.aphelion DESC MATCH p1 = (n)-[*0..3]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..3]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)";
        PagingAndSortingQuery orbitsQuery = this.query.findByType("ORBITS", 3);
        this.check(cypher, orbitsQuery.setSortOrder(this.sortOrder.add(SortOrder.Direction.DESC, new String[]{"distance", "aphelion"})).getStatement());
        this.check(cypher, orbitsQuery.setSortOrder(new SortOrder(SortOrder.Direction.DESC, new String[]{"distance", "aphelion"})).getStatement());
        this.check(cypher, orbitsQuery.setSortOrder(new SortOrder().desc(new String[]{"distance", "aphelion"})).getStatement());
    }

    @Test
    public void testDefaultMultipleSortOrders() {
        String cypher = "MATCH ()-[r0:`ORBITS`]-()  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m ORDER BY r0.distance,r0.aphelion MATCH p1 = (n)-[*0..3]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..3]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)";
        PagingAndSortingQuery orbitsQuery = this.query.findByType("ORBITS", 3);
        this.check(cypher, orbitsQuery.setSortOrder(this.sortOrder.add(new String[]{"distance", "aphelion"})).getStatement());
        this.check(cypher, orbitsQuery.setSortOrder(new SortOrder(new String[]{"distance", "aphelion"})).getStatement());
        this.check(cypher, orbitsQuery.setSortOrder(new SortOrder().asc(new String[]{"distance", "aphelion"})).getStatement());
    }

    @Test
    public void testDifferentSortDirections() {
        this.sortOrder.add(SortOrder.Direction.DESC, new String[]{"type"}).add(new String[]{"name"});
        String statement = this.query.findByType("ORBITS", 3).setSortOrder(this.sortOrder).getStatement();
        String expected = "MATCH ()-[r0:`ORBITS`]-()  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m ORDER BY r0.type DESC,r0.name MATCH p1 = (n)-[*0..3]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..3]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)";
        Assertions.assertThat((String)statement).isEqualTo((Object)expected);
    }

    private void check(String expected, String actual) {
        Assertions.assertThat((String)actual).isEqualTo((Object)expected);
    }
}

