/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy.impl;

import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.CypherQuery;
import org.neo4j.ogm.session.request.strategy.DeleteStatements;
import org.neo4j.ogm.session.request.strategy.impl.NodeDeleteStatements;

public class NodeDeleteStatementsTest {
    private final DeleteStatements statements = new NodeDeleteStatements();

    @Test
    public void testDeleteOne() throws Exception {
        Assertions.assertThat((String)this.statements.delete(Long.valueOf(0L)).getStatement()).isEqualTo((Object)"MATCH (n) WHERE ID(n) = { id } OPTIONAL MATCH (n)-[r0]-() DELETE r0, n");
    }

    @Test
    public void testDeleteMany() throws Exception {
        Assertions.assertThat((String)this.statements.delete(Arrays.asList(1L, 2L)).getStatement()).isEqualTo((Object)"MATCH (n) WHERE ID(n) in { ids } OPTIONAL MATCH (n)-[r0]-() DELETE r0, n");
    }

    @Test
    public void testDeleteAll() throws Exception {
        Assertions.assertThat((String)this.statements.deleteAll().getStatement()).isEqualTo((Object)"MATCH (n) OPTIONAL MATCH (n)-[r0]-() DELETE r0, n");
    }

    @Test
    public void testDeleteWithLabel() throws Exception {
        Assertions.assertThat((String)this.statements.delete("TRAFFIC_WARDENS").getStatement()).isEqualTo((Object)"MATCH (n:`TRAFFIC_WARDENS`) OPTIONAL MATCH (n)-[r0]-() DELETE r0, n");
    }

    @Test
    public void testDeleteWithLabelAndFilters() throws Exception {
        CypherQuery query = this.statements.delete("INFLUENCE", (Iterable)new Filters().add(new Filter("score", ComparisonOperator.EQUALS, (Object)-12.2)));
        Assertions.assertThat((String)query.getStatement()).isEqualTo((Object)"MATCH (n:`INFLUENCE`) WHERE n.`score` = { `score_0` } WITH n OPTIONAL MATCH (n)-[r0]-() DELETE r0, n");
    }

    @Test
    public void testDeleteWithLabelAndFiltersAndList() throws Exception {
        CypherQuery query = this.statements.deleteAndList("INFLUENCE", (Iterable)new Filters().add(new Filter("score", ComparisonOperator.EQUALS, (Object)-12.2)));
        Assertions.assertThat((String)query.getStatement()).isEqualTo((Object)"MATCH (n:`INFLUENCE`) WHERE n.`score` = { `score_0` } WITH n OPTIONAL MATCH (n)-[r0]-() DELETE r0, n RETURN ID(n)");
    }
}

