/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy.impl;

import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.PagingAndSortingQuery;
import org.neo4j.ogm.session.request.strategy.impl.NodeQueryStatements;

public class NodeEntityQueryPagingTest {
    private final NodeQueryStatements<Long> queryStatements = new NodeQueryStatements();
    private Pagination paging = new Pagination(2, 2);
    private Filters filters = new Filters().add(new Filter("name", ComparisonOperator.EQUALS, (Object)"velociraptor"));

    @Test
    public void testFindByType() {
        Assertions.assertThat((String)this.queryStatements.findByType("Raptor", 1).setPagination(this.paging).getStatement()).isEqualTo((Object)"MATCH (n:`Raptor`) WITH n SKIP 4 LIMIT 2 MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByTypeZeroDepth() throws Exception {
        Assertions.assertThat((String)this.queryStatements.findByType("Raptor", 0).setPagination(this.paging).getStatement()).isEqualTo((Object)"MATCH (n:`Raptor`) WITH n SKIP 4 LIMIT 2 RETURN n");
    }

    @Test
    public void testFindByTypeInfiniteDepth() throws Exception {
        Assertions.assertThat((String)this.queryStatements.findByType("Raptor", -1).setPagination(this.paging).getStatement()).isEqualTo((Object)"MATCH (n:`Raptor`) WITH n SKIP 4 LIMIT 2 MATCH p=(n)-[*0..]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByProperty() {
        Assertions.assertThat((String)this.queryStatements.findByType("Raptor", this.filters, 2).setPagination(this.paging).getStatement()).isEqualTo((Object)"MATCH (n:`Raptor`) WHERE n.`name` = { `name_0` } WITH n SKIP 4 LIMIT 2 MATCH p=(n)-[*0..2]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByPropertyZeroDepth() {
        Assertions.assertThat((String)this.queryStatements.findByType("Raptor", this.filters, 0).setPagination(this.paging).getStatement()).isEqualTo((Object)"MATCH (n:`Raptor`) WHERE n.`name` = { `name_0` } WITH n SKIP 4 LIMIT 2 RETURN n");
    }

    @Test
    public void testFindByPropertyInfiniteDepth() {
        Assertions.assertThat((String)this.queryStatements.findByType("Raptor", this.filters, -1).setPagination(this.paging).getStatement()).isEqualTo((Object)"MATCH (n:`Raptor`) WHERE n.`name` = { `name_0` } WITH n SKIP 4 LIMIT 2 MATCH p=(n)-[*0..]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindAllByType() throws Exception {
        Assertions.assertThat((String)this.queryStatements.findAllByType("Raptor", Arrays.asList(1L, 2L), 1).setPagination(this.paging).getStatement()).isEqualTo((Object)"MATCH (n:`Raptor`) WHERE ID(n) IN { ids } WITH n SKIP 4 LIMIT 2 MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindAllByTypeZeroDepth() throws Exception {
        Assertions.assertThat((String)this.queryStatements.findAllByType("Raptor", Arrays.asList(1L, 2L), 0).setPagination(this.paging).getStatement()).isEqualTo((Object)"MATCH (n:`Raptor`) WHERE ID(n) IN { ids } WITH n SKIP 4 LIMIT 2 RETURN n");
    }

    @Test
    public void testFindAllByTypeInfiniteDepth() throws Exception {
        Assertions.assertThat((String)this.queryStatements.findAllByType("Raptor", Arrays.asList(1L, 2L), -1).setPagination(this.paging).getStatement()).isEqualTo((Object)"MATCH (n:`Raptor`) WHERE ID(n) IN { ids } WITH n SKIP 4 LIMIT 2 MATCH p=(n)-[*0..]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByTypeAndOffset() {
        Pagination pagination = new Pagination(1, 5);
        pagination.setOffset(Integer.valueOf(3));
        PagingAndSortingQuery query = this.queryStatements.findByType("Raptor", 1).setPagination(pagination);
        Assertions.assertThat((String)query.getStatement()).isEqualTo((Object)"MATCH (n:`Raptor`) WITH n SKIP 3 LIMIT 5 MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
    }
}

