/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy.impl;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.session.request.strategy.impl.NodeQueryStatements;

public class NodeEntityQuerySortingTest {
    private final NodeQueryStatements query = new NodeQueryStatements();
    private SortOrder sortOrder;
    private Filters filters;

    @Before
    public void setUp() {
        this.sortOrder = new SortOrder();
        this.filters = new Filters();
    }

    @Test
    public void testFindByType() {
        this.sortOrder.add(new String[]{"name"});
        this.check("MATCH (n:`Raptor`) WITH n ORDER BY n.name MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)", this.query.findByType("Raptor", 1).setSortOrder(this.sortOrder).getStatement());
    }

    @Test
    public void testFindByProperty() {
        this.sortOrder.add(SortOrder.Direction.DESC, new String[]{"weight"});
        this.filters.add(new Filter("name", ComparisonOperator.EQUALS, (Object)"velociraptor"));
        this.check("MATCH (n:`Raptor`) WHERE n.`name` = { `name_0` } WITH n ORDER BY n.weight DESC MATCH p=(n)-[*0..2]-(m) RETURN p, ID(n)", this.query.findByType("Raptor", this.filters, 2).setSortOrder(this.sortOrder).getStatement());
    }

    @Test
    public void testFindByTypeDepthZero() {
        this.sortOrder.add(SortOrder.Direction.DESC, new String[]{"name"});
        this.check("MATCH (n:`Raptor`) WITH n ORDER BY n.name DESC RETURN n", this.query.findByType("Raptor", 0).setSortOrder(this.sortOrder).getStatement());
    }

    @Test
    public void testByPropertyDepthZero() {
        this.filters.add(new Filter("name", ComparisonOperator.EQUALS, (Object)"velociraptor"));
        this.sortOrder.add(SortOrder.Direction.DESC, new String[]{"weight"});
        this.check("MATCH (n:`Raptor`) WHERE n.`name` = { `name_0` } WITH n ORDER BY n.weight DESC RETURN n", this.query.findByType("Raptor", this.filters, 0).setSortOrder(this.sortOrder).getStatement());
    }

    @Test
    public void testFindByTypeDepthInfinite() {
        this.sortOrder.add(SortOrder.Direction.DESC, new String[]{"name"});
        this.check("MATCH (n:`Raptor`) WITH n ORDER BY n.name DESC MATCH p=(n)-[*0..]-(m) RETURN p, ID(n)", this.query.findByType("Raptor", -1).setSortOrder(this.sortOrder).getStatement());
    }

    @Test
    public void testFindByPropertyDepthInfinite() {
        this.sortOrder.add(SortOrder.Direction.DESC, new String[]{"name"});
        this.filters.add(new Filter("name", ComparisonOperator.EQUALS, (Object)"velociraptor"));
        this.check("MATCH (n:`Raptor`) WHERE n.`name` = { `name_0` } WITH n ORDER BY n.name DESC MATCH p=(n)-[*0..]-(m) RETURN p, ID(n)", this.query.findByType("Raptor", this.filters, -1).setSortOrder(this.sortOrder).getStatement());
    }

    @Test
    public void testMultipleSortOrders() {
        String cypher = "MATCH (n:`Raptor`) WITH n ORDER BY n.age DESC,n.name DESC RETURN n";
        this.check(cypher, this.query.findByType("Raptor", 0).setSortOrder(this.sortOrder.add(SortOrder.Direction.DESC, new String[]{"age", "name"})).getStatement());
        this.check(cypher, this.query.findByType("Raptor", 0).setSortOrder(new SortOrder(SortOrder.Direction.DESC, new String[]{"age", "name"})).getStatement());
        this.check(cypher, this.query.findByType("Raptor", 0).setSortOrder(new SortOrder().desc(new String[]{"age", "name"})).getStatement());
    }

    @Test
    public void testDefaultMultipleSortOrders() {
        String cypher = "MATCH (n:`Raptor`) WITH n ORDER BY n.age,n.name RETURN n";
        this.check(cypher, this.query.findByType("Raptor", 0).setSortOrder(this.sortOrder.add(new String[]{"age", "name"})).getStatement());
        this.check(cypher, this.query.findByType("Raptor", 0).setSortOrder(new SortOrder(new String[]{"age", "name"})).getStatement());
        this.check(cypher, this.query.findByType("Raptor", 0).setSortOrder(new SortOrder().asc(new String[]{"age", "name"})).getStatement());
    }

    @Test
    public void testDifferentSortDirections() {
        this.sortOrder.add(SortOrder.Direction.DESC, new String[]{"age"}).add(new String[]{"name"});
        this.check("MATCH (n:`Raptor`) WITH n ORDER BY n.age DESC,n.name RETURN n", this.query.findByType("Raptor", 0).setSortOrder(this.sortOrder).getStatement());
    }

    private void check(String expected, String actual) {
        Assertions.assertThat((String)actual).isEqualTo((Object)expected);
    }
}

