/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.function.DistanceComparison;
import org.neo4j.ogm.cypher.function.DistanceFromPoint;
import org.neo4j.ogm.cypher.query.PagingAndSortingQuery;
import org.neo4j.ogm.exception.core.MissingOperatorException;
import org.neo4j.ogm.session.request.strategy.LoadClauseBuilder;
import org.neo4j.ogm.session.request.strategy.QueryStatements;
import org.neo4j.ogm.session.request.strategy.impl.NodeQueryStatements;
import org.neo4j.ogm.session.request.strategy.impl.PathNodeLoadClauseBuilder;

public class NodeQueryStatementsTest {
    private final QueryStatements<Long> queryStatements = new NodeQueryStatements();
    private final QueryStatements<String> primaryQueryStatements = new NodeQueryStatements("uuid", (LoadClauseBuilder)new PathNodeLoadClauseBuilder());

    @Test
    public void testFindOne() throws Exception {
        Assertions.assertThat((String)this.queryStatements.findOne((Serializable)Long.valueOf(0L), 2).getStatement()).isEqualTo((Object)"MATCH (n) WHERE ID(n) = { id } WITH n MATCH p=(n)-[*0..2]-(m) RETURN p");
    }

    @Test
    public void testFindOnePrimaryIndex() throws Exception {
        PagingAndSortingQuery query = this.primaryQueryStatements.findOne((Serializable)((Object)"test-uuid"), 2);
        Assertions.assertThat((String)query.getStatement()).isEqualTo((Object)"MATCH (n) WHERE n.`uuid` = { id } WITH n MATCH p=(n)-[*0..2]-(m) RETURN p");
        Assertions.assertThat((Map)query.getParameters()).containsEntry((Object)"id", (Object)"test-uuid");
    }

    @Test
    public void testFindOneByType() throws Exception {
        PagingAndSortingQuery query = this.queryStatements.findOneByType("Orbit", (Serializable)Long.valueOf(0L), 2);
        Assertions.assertThat((String)query.getStatement()).isEqualTo((Object)"MATCH (n:`Orbit`) WHERE ID(n) = { id } WITH n MATCH p=(n)-[*0..2]-(m) RETURN p");
        Assertions.assertThat((Map)query.getParameters()).containsEntry((Object)"id", (Object)0L);
        Assertions.assertThat((String)this.queryStatements.findOne((Serializable)Long.valueOf(0L), 2).getStatement()).isEqualTo((Object)this.queryStatements.findOneByType("", (Serializable)Long.valueOf(0L), 2).getStatement());
        Assertions.assertThat((String)this.queryStatements.findOne((Serializable)Long.valueOf(0L), 2).getStatement()).isEqualTo((Object)this.queryStatements.findOneByType(null, (Serializable)Long.valueOf(0L), 2).getStatement());
    }

    @Test
    public void testFindOneByTypePrimaryIndex() throws Exception {
        PagingAndSortingQuery query = this.primaryQueryStatements.findOneByType("Orbit", (Serializable)((Object)"test-uuid"), 2);
        Assertions.assertThat((String)query.getStatement()).isEqualTo((Object)"MATCH (n:`Orbit`) WHERE n.`uuid` = { id } WITH n MATCH p=(n)-[*0..2]-(m) RETURN p");
        Assertions.assertThat((Map)query.getParameters()).containsEntry((Object)"id", (Object)"test-uuid");
    }

    @Test
    public void testFindOneByTypePrimaryIndexInfiniteDepth() throws Exception {
        PagingAndSortingQuery query = this.primaryQueryStatements.findOneByType("Orbit", (Serializable)((Object)"test-uuid"), -1);
        Assertions.assertThat((String)query.getStatement()).isEqualTo((Object)"MATCH (n:`Orbit`) WHERE n.`uuid` = { id } WITH n MATCH p=(n)-[*0..]-(m) RETURN p");
        Assertions.assertThat((Map)query.getParameters()).containsEntry((Object)"id", (Object)"test-uuid");
    }

    @Test
    public void testFindByLabel() throws Exception {
        String statement = this.queryStatements.findByType("Orbit", 3).getStatement();
        Assertions.assertThat((String)statement).isEqualTo((Object)"MATCH (n:`Orbit`) WITH n MATCH p=(n)-[*0..3]-(m) RETURN p");
    }

    @Test
    public void testFindByDistance() {
        DistanceComparison function = new DistanceComparison(new DistanceFromPoint(Double.valueOf(37.4), Double.valueOf(112.9), Double.valueOf(1000.0)));
        Filters filters = new Filters().add(new Filter(function, ComparisonOperator.EQUALS));
        String statement = this.queryStatements.findByType("Restaurant", filters, 4).getStatement();
        Assertions.assertThat((String)statement).isEqualTo((Object)"MATCH (n:`Restaurant`) WHERE distance(point({latitude: n.latitude, longitude: n.longitude}),point({latitude:{lat}, longitude:{lon}})) = {distance} WITH n MATCH p=(n)-[*0..4]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByPropertyIsNull() {
        Filter isNull = new Filter("score", ComparisonOperator.IS_NULL, null);
        String statement = this.queryStatements.findByType("Restaurant", new Filters().add(isNull), 3).getStatement();
        Assertions.assertThat((String)statement).isEqualTo((Object)"MATCH (n:`Restaurant`) WHERE n.`score` IS NULL WITH n MATCH p=(n)-[*0..3]-(m) RETURN p, ID(n)");
        Filter isNotNull = new Filter("score", ComparisonOperator.IS_NULL, null);
        isNotNull.setNegated(true);
        statement = this.queryStatements.findByType("Restaurant", new Filters().add(isNotNull), 3).getStatement();
        Assertions.assertThat((String)statement).isEqualTo((Object)"MATCH (n:`Restaurant`) WHERE NOT(n.`score` IS NULL ) WITH n MATCH p=(n)-[*0..3]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindAllByLabel() throws Exception {
        Assertions.assertThat((String)this.queryStatements.findAllByType("Orbit", Arrays.asList(1L, 2L, 3L), 0).getStatement()).isEqualTo((Object)"MATCH (n:`Orbit`) WHERE ID(n) IN { ids } WITH n RETURN n");
    }

    @Test
    public void testFindAllByLabelPrimaryIndex() throws Exception {
        List<String> ids = Arrays.asList("uuid-1", "uuid-2");
        PagingAndSortingQuery query = this.primaryQueryStatements.findAllByType("Orbit", ids, 0);
        Assertions.assertThat((String)query.getStatement()).isEqualTo((Object)"MATCH (n:`Orbit`) WHERE n.`uuid` IN { ids } WITH n RETURN n");
        Assertions.assertThat((Map)query.getParameters()).containsEntry((Object)"ids", ids);
    }

    @Test
    public void testFindAllByLabelPrimaryIndexInfiniteDepth() throws Exception {
        List<String> ids = Arrays.asList("uuid-1", "uuid-2");
        PagingAndSortingQuery query = this.primaryQueryStatements.findAllByType("Orbit", ids, -1);
        Assertions.assertThat((String)query.getStatement()).isEqualTo((Object)"MATCH (n:`Orbit`) WHERE n.`uuid` IN { ids } WITH n MATCH p=(n)-[*0..]-(m) RETURN p");
        Assertions.assertThat((Map)query.getParameters()).containsEntry((Object)"ids", ids);
    }

    @Test
    public void testFindAllByLabelDepthOne() throws Exception {
        Assertions.assertThat((String)this.queryStatements.findAllByType("Orbit", Arrays.asList(1L, 2L, 3L), 1).getStatement()).isEqualTo((Object)"MATCH (n:`Orbit`) WHERE ID(n) IN { ids } WITH n MATCH p=(n)-[*0..1]-(m) RETURN p");
    }

    @Test
    public void testFindAllByLabelDepthInfinity() throws Exception {
        Assertions.assertThat((String)this.queryStatements.findAllByType("Orbit", Arrays.asList(1L, 2L, 3L), -1).getStatement()).isEqualTo((Object)"MATCH (n:`Orbit`) WHERE ID(n) IN { ids } WITH n MATCH p=(n)-[*0..]-(m) RETURN p");
    }

    @Test
    public void testFindByProperty() throws Exception {
        String statement = this.queryStatements.findByType("Asteroid", new Filters().add(new Filter("diameter", ComparisonOperator.EQUALS, (Object)60.2)), 4).getStatement();
        Assertions.assertThat((String)statement).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`diameter` = { `diameter_0` } WITH n MATCH p=(n)-[*0..4]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindOneZeroDepth() throws Exception {
        Assertions.assertThat((String)this.queryStatements.findOne((Serializable)Long.valueOf(0L), 0).getStatement()).isEqualTo((Object)"MATCH (n) WHERE ID(n) = { id } WITH n RETURN n");
    }

    @Test
    public void testFindOneZeroDepthPrimaryIndex() throws Exception {
        PagingAndSortingQuery query = this.primaryQueryStatements.findOne((Serializable)((Object)"test-uuid"), 0);
        Assertions.assertThat((String)query.getStatement()).isEqualTo((Object)"MATCH (n) WHERE n.`uuid` = { id } WITH n RETURN n");
    }

    @Test
    public void testFindByLabelZeroDepth() throws Exception {
        Assertions.assertThat((String)this.queryStatements.findByType("Orbit", 0).getStatement()).isEqualTo((Object)"MATCH (n:`Orbit`) WITH n RETURN n");
    }

    @Test
    public void testFindByPropertyZeroDepth() throws Exception {
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(new Filter("diameter", ComparisonOperator.EQUALS, (Object)60.2)), 0).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`diameter` = { `diameter_0` } WITH n RETURN n");
    }

    @Test
    public void testFindByPropertyWithInfiniteValue() throws Exception {
        PagingAndSortingQuery pagingAndSortingQuery = this.queryStatements.findByType("Asteroid", new Filters().add(new Filter("albedo", ComparisonOperator.EQUALS, (Object)-12.2)), 0);
        Assertions.assertThat((String)pagingAndSortingQuery.getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`albedo` = { `albedo_0` } WITH n RETURN n");
        Assertions.assertThat((double)((Double)pagingAndSortingQuery.getParameters().get("albedo_0"))).isEqualTo(-12.2, Assertions.within((Double)0.005));
    }

    @Test
    public void testFindByLabelWithIllegalCharacters() throws Exception {
        Assertions.assertThat((String)this.queryStatements.findByType("l'artiste", 3).getStatement()).isEqualTo((Object)"MATCH (n:`l'artiste`) WITH n MATCH p=(n)-[*0..3]-(m) RETURN p");
    }

    @Test
    public void testFindOneInfiniteDepth() throws Exception {
        Assertions.assertThat((String)this.queryStatements.findOne((Serializable)Long.valueOf(0L), -1).getStatement()).isEqualTo((Object)"MATCH (n) WHERE ID(n) = { id } WITH n MATCH p=(n)-[*0..]-(m) RETURN p");
    }

    @Test
    public void testFindByLabelInfiniteDepth() throws Exception {
        Assertions.assertThat((String)this.queryStatements.findByType("Orbit", -1).getStatement()).isEqualTo((Object)"MATCH (n:`Orbit`) WITH n MATCH p=(n)-[*0..]-(m) RETURN p");
    }

    @Test
    public void testFindByPropertyInfiniteDepth() throws Exception {
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(new Filter("diameter", ComparisonOperator.EQUALS, (Object)60.2)), -1).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`diameter` = { `diameter_0` } WITH n MATCH p=(n)-[*0..]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByPropertyWithIllegalCharacters() throws Exception {
        Assertions.assertThat((String)this.queryStatements.findByType("Studio", new Filters().add(new Filter("studio-name", ComparisonOperator.EQUALS, (Object)"Abbey Road Studios")), 3).getStatement()).isEqualTo((Object)"MATCH (n:`Studio`) WHERE n.`studio-name` = { `studio-name_0` } WITH n MATCH p=(n)-[*0..3]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByPropertyGreaterThan() throws Exception {
        Filter parameter = new Filter("diameter", ComparisonOperator.GREATER_THAN, (Object)60);
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(parameter), 4).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`diameter` > { `diameter_0` } WITH n MATCH p=(n)-[*0..4]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByPropertyGreaterThanEqual() throws Exception {
        Filter parameter = new Filter("diameter", ComparisonOperator.GREATER_THAN_EQUAL, (Object)60);
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(parameter), 4).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`diameter` >= { `diameter_0` } WITH n MATCH p=(n)-[*0..4]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByPropertyLessThan() throws Exception {
        Filter parameter = new Filter("diameter", ComparisonOperator.LESS_THAN, (Object)60);
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(parameter), 4).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`diameter` < { `diameter_0` } WITH n MATCH p=(n)-[*0..4]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByPropertyLessThanEqual() throws Exception {
        Filter parameter = new Filter("diameter", ComparisonOperator.LESS_THAN_EQUAL, (Object)60);
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(parameter), 4).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`diameter` <= { `diameter_0` } WITH n MATCH p=(n)-[*0..4]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByChainedAndedProperties() {
        Filter planetParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"Earth");
        planetParam.setNestedPropertyName("collidesWith");
        planetParam.setNestedEntityTypeLabel("Planet");
        planetParam.setRelationshipType("COLLIDES");
        planetParam.setRelationshipDirection("OUTGOING");
        Filter moonParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"Moon");
        moonParam.setNestedPropertyName("moon");
        moonParam.setNestedEntityTypeLabel("Moon");
        moonParam.setRelationshipType("ORBITS");
        moonParam.setRelationshipDirection("INCOMING");
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(planetParam).and(moonParam), 1).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) MATCH (m0:`Planet`) WHERE m0.`name` = { `collidesWith_name_0` } MATCH (m1:`Moon`) WHERE m1.`name` = { `moon_name_1` } MATCH (n)-[:`COLLIDES`]->(m0) MATCH (n)<-[:`ORBITS`]-(m1) WITH DISTINCT n MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByChainedOredProperties() {
        Filter planetParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"Earth");
        Filter moonParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"Moon");
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(planetParam).or(moonParam), 1).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`name` = { `name_0` } OR n.`name` = { `name_1` } WITH n MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByMultipleAndPropertiesLessThan() {
        Filter nameParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"AST-1");
        Filter diameterParam = new Filter("diameter", ComparisonOperator.LESS_THAN, (Object)60);
        diameterParam.setBooleanOperator(BooleanOperator.AND);
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(nameParam).add(diameterParam), 2).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`name` = { `name_0` } AND n.`diameter` < { `diameter_1` } WITH n MATCH p=(n)-[*0..2]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByMultipleAndPropertiesGreaterThan() {
        Filter nameParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"AST-1");
        Filter diameterParam = new Filter("diameter", ComparisonOperator.GREATER_THAN, (Object)60);
        diameterParam.setBooleanOperator(BooleanOperator.AND);
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(nameParam).add(diameterParam), 2).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`name` = { `name_0` } AND n.`diameter` > { `diameter_1` } WITH n MATCH p=(n)-[*0..2]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByMultipleAndPropertiesGreaterThanWithDifferentOrder() {
        Filter nameParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"AST-1");
        nameParam.setBooleanOperator(BooleanOperator.AND);
        Filter diameterParam = new Filter("diameter", ComparisonOperator.GREATER_THAN, (Object)60);
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(diameterParam).add(nameParam), 2).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`diameter` > { `diameter_0` } AND n.`name` = { `name_1` } WITH n MATCH p=(n)-[*0..2]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByMultipleOrPropertiesGreaterThan() {
        Filter nameParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"AST-1");
        Filter diameterParam = new Filter("diameter", ComparisonOperator.GREATER_THAN, (Object)60);
        diameterParam.setBooleanOperator(BooleanOperator.OR);
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(nameParam).add(diameterParam), 2).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`name` = { `name_0` } OR n.`diameter` > { `diameter_1` } WITH n MATCH p=(n)-[*0..2]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByMultipleOrPropertiesLessThan() {
        Filter nameParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"AST-1");
        Filter diameterParam = new Filter("diameter", ComparisonOperator.LESS_THAN, (Object)60);
        diameterParam.setBooleanOperator(BooleanOperator.OR);
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(nameParam).add(diameterParam), 2).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`name` = { `name_0` } OR n.`diameter` < { `diameter_1` } WITH n MATCH p=(n)-[*0..2]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByMultipleOrPropertiesGreaterThanWithDifferentOrder() {
        Filter nameParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"AST-1");
        nameParam.setBooleanOperator(BooleanOperator.OR);
        Filter diameterParam = new Filter("diameter", ComparisonOperator.GREATER_THAN, (Object)60);
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(diameterParam).add(nameParam), 2).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`diameter` > { `diameter_0` } OR n.`name` = { `name_1` } WITH n MATCH p=(n)-[*0..2]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByNestedPropertyOutgoing() {
        Filter planetParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"Earth");
        planetParam.setNestedPropertyName("collidesWith");
        planetParam.setNestedEntityTypeLabel("Planet");
        planetParam.setRelationshipType("COLLIDES");
        planetParam.setRelationshipDirection("OUTGOING");
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(planetParam), 1).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) MATCH (m0:`Planet`) WHERE m0.`name` = { `collidesWith_name_0` } MATCH (n)-[:`COLLIDES`]->(m0) WITH DISTINCT n MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByNestedPropertySameEntityType() {
        Filter filter = new Filter("name", ComparisonOperator.EQUALS, (Object)"Vesta");
        filter.setNestedPropertyName("collidesWith");
        filter.setNestedEntityTypeLabel("Asteroid");
        filter.setRelationshipType("COLLIDES");
        filter.setRelationshipDirection("OUTGOING");
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(filter), 1).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) MATCH (m0:`Asteroid`) WHERE m0.`name` = { `collidesWith_name_0` } MATCH (n)-[:`COLLIDES`]->(m0) WITH DISTINCT n MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByNestedPropertyIncoming() {
        Filter planetParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"Earth");
        planetParam.setNestedPropertyName("collidesWith");
        planetParam.setNestedEntityTypeLabel("Planet");
        planetParam.setRelationshipType("COLLIDES");
        planetParam.setRelationshipDirection("INCOMING");
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(planetParam), 1).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) MATCH (m0:`Planet`) WHERE m0.`name` = { `collidesWith_name_0` } MATCH (n)<-[:`COLLIDES`]-(m0) WITH DISTINCT n MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByNestedPropertyUndirected() {
        Filter planetParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"Earth");
        planetParam.setNestedPropertyName("collidesWith");
        planetParam.setNestedEntityTypeLabel("Planet");
        planetParam.setRelationshipType("COLLIDES");
        planetParam.setRelationshipDirection("UNDIRECTED");
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(planetParam), 1).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) MATCH (m0:`Planet`) WHERE m0.`name` = { `collidesWith_name_0` } MATCH (n)-[:`COLLIDES`]-(m0) WITH DISTINCT n MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByMultipleNestedProperties() {
        Filter diameterParam = new Filter("diameter", ComparisonOperator.GREATER_THAN, (Object)60);
        Filter planetParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"Earth");
        planetParam.setBooleanOperator(BooleanOperator.AND);
        planetParam.setNestedPropertyName("collidesWith");
        planetParam.setNestedEntityTypeLabel("Planet");
        planetParam.setRelationshipType("COLLIDES");
        planetParam.setRelationshipDirection("OUTGOING");
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(diameterParam).add(planetParam), 1).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`diameter` > { `diameter_0` } MATCH (m0:`Planet`) WHERE m0.`name` = { `collidesWith_name_1` } MATCH (n)-[:`COLLIDES`]->(m0) WITH DISTINCT n MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByMultipleNestedPropertiesInfiniteDepth() {
        Filter diameterParam = new Filter("diameter", ComparisonOperator.GREATER_THAN, (Object)60);
        Filter planetParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"Earth");
        planetParam.setBooleanOperator(BooleanOperator.AND);
        planetParam.setNestedPropertyName("collidesWith");
        planetParam.setNestedEntityTypeLabel("Planet");
        planetParam.setRelationshipType("COLLIDES");
        planetParam.setRelationshipDirection("OUTGOING");
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(diameterParam).add(planetParam), -1).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`diameter` > { `diameter_0` } MATCH (m0:`Planet`) WHERE m0.`name` = { `collidesWith_name_1` } MATCH (n)-[:`COLLIDES`]->(m0) WITH DISTINCT n MATCH p=(n)-[*0..]-(m) RETURN p, ID(n)");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFindByMultipleNestedPropertiesOred() {
        Filter diameterParam = new Filter("diameter", ComparisonOperator.GREATER_THAN, (Object)60);
        Filter planetParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"Earth");
        planetParam.setBooleanOperator(BooleanOperator.OR);
        planetParam.setNestedPropertyName("collidesWith");
        planetParam.setNestedEntityTypeLabel("Planet");
        planetParam.setRelationshipType("COLLIDES");
        planetParam.setRelationshipDirection("OUTGOING");
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(diameterParam).add(planetParam), 1).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`diameter` > { `diameter` } OPTIONAL MATCH (m0:`Planet`) WHERE m0.`name` = { `collidesWith_name` } OPTIONAL MATCH (n)-[:`COLLIDES`]->(m0) WITH n MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFindByMultipleNestedPropertiesOredDepth0() {
        Filter diameterParam = new Filter("diameter", ComparisonOperator.GREATER_THAN, (Object)60);
        Filter planetParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"Earth");
        planetParam.setBooleanOperator(BooleanOperator.OR);
        planetParam.setNestedPropertyName("collidesWith");
        planetParam.setNestedEntityTypeLabel("Planet");
        planetParam.setRelationshipType("COLLIDES");
        planetParam.setRelationshipDirection("OUTGOING");
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(diameterParam).add(planetParam), 0).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`diameter` > { `diameter` } OPTIONAL MATCH (m0:`Planet`) WHERE m0.`name` = { `collidesWith_name` } OPTIONAL MATCH (n)-[:`COLLIDES`]->(m0) RETURN n");
    }

    @Test
    public void testFindByNestedREProperty() {
        Filter planetParam = new Filter("totalDestructionProbability", ComparisonOperator.EQUALS, (Object)"20");
        planetParam.setNestedPropertyName("collision");
        planetParam.setNestedEntityTypeLabel("Collision");
        planetParam.setNestedRelationshipEntity(true);
        planetParam.setRelationshipType("COLLIDES");
        planetParam.setRelationshipDirection("OUTGOING");
        planetParam.setNestedRelationshipEntity(true);
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(planetParam), 1).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) MATCH (n)-[r0:`COLLIDES`]->(m0) WHERE r0.`totalDestructionProbability` = { `collision_totalDestructionProbability_0` } WITH DISTINCT n MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByMultipleNestedREProperty() {
        Filter planetParam = new Filter("totalDestructionProbability", ComparisonOperator.EQUALS, (Object)"20");
        planetParam.setNestedPropertyName("collision");
        planetParam.setNestedEntityTypeLabel("Collision");
        planetParam.setNestedRelationshipEntity(true);
        planetParam.setRelationshipType("COLLIDES");
        planetParam.setRelationshipDirection("OUTGOING");
        planetParam.setNestedRelationshipEntity(true);
        Filter satelliteParam = new Filter("signalStrength", ComparisonOperator.GREATER_THAN_EQUAL, (Object)"400");
        satelliteParam.setBooleanOperator(BooleanOperator.AND);
        satelliteParam.setNestedPropertyName("monitoringSatellites");
        satelliteParam.setNestedEntityTypeLabel("Satellite");
        satelliteParam.setNestedRelationshipEntity(true);
        satelliteParam.setRelationshipType("MONITORED_BY");
        satelliteParam.setRelationshipDirection("INCOMING");
        satelliteParam.setNestedRelationshipEntity(true);
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(planetParam).add(satelliteParam), 1).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) MATCH (n)-[r0:`COLLIDES`]->(m0) WHERE r0.`totalDestructionProbability` = { `collision_totalDestructionProbability_0` } MATCH (n)<-[r1:`MONITORED_BY`]-(m1) WHERE r1.`signalStrength` >= { `monitoringSatellites_signalStrength_1` } WITH DISTINCT n MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByNestedBaseAndREProperty() {
        Filter planetParam = new Filter("totalDestructionProbability", ComparisonOperator.EQUALS, (Object)"20");
        planetParam.setNestedPropertyName("collision");
        planetParam.setNestedEntityTypeLabel("Collision");
        planetParam.setNestedRelationshipEntity(true);
        planetParam.setRelationshipType("COLLIDES");
        planetParam.setRelationshipDirection("OUTGOING");
        planetParam.setNestedRelationshipEntity(true);
        Filter moonParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"Moon");
        moonParam.setNestedPropertyName("moon");
        moonParam.setNestedEntityTypeLabel("Moon");
        moonParam.setRelationshipType("ORBITS");
        moonParam.setRelationshipDirection("INCOMING");
        moonParam.setBooleanOperator(BooleanOperator.AND);
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(new Filter[]{planetParam, moonParam}), 1).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) MATCH (n)-[r0:`COLLIDES`]->(m0) WHERE r0.`totalDestructionProbability` = { `collision_totalDestructionProbability_0` } MATCH (m1:`Moon`) WHERE m1.`name` = { `moon_name_1` } MATCH (n)<-[:`ORBITS`]-(m1) WITH DISTINCT n MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByDifferentNestedPropertiesAnded() {
        Filter planetParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"Earth");
        planetParam.setNestedPropertyName("collidesWith");
        planetParam.setNestedEntityTypeLabel("Planet");
        planetParam.setRelationshipType("COLLIDES");
        planetParam.setRelationshipDirection("OUTGOING");
        Filter moonParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"Moon");
        moonParam.setNestedPropertyName("moon");
        moonParam.setNestedEntityTypeLabel("Moon");
        moonParam.setRelationshipType("ORBITS");
        moonParam.setRelationshipDirection("INCOMING");
        moonParam.setBooleanOperator(BooleanOperator.AND);
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(planetParam).add(moonParam), 1).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) MATCH (m0:`Planet`) WHERE m0.`name` = { `collidesWith_name_0` } MATCH (m1:`Moon`) WHERE m1.`name` = { `moon_name_1` } MATCH (n)-[:`COLLIDES`]->(m0) MATCH (n)<-[:`ORBITS`]-(m1) WITH DISTINCT n MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFindByDifferentNestedPropertiesOred() {
        Filter planetParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"Earth");
        planetParam.setNestedPropertyName("collidesWith");
        planetParam.setNestedEntityTypeLabel("Planet");
        planetParam.setRelationshipType("COLLIDES");
        planetParam.setRelationshipDirection("OUTGOING");
        Filter moonParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"Moon");
        moonParam.setNestedPropertyName("moon");
        moonParam.setNestedEntityTypeLabel("Moon");
        moonParam.setRelationshipType("ORBITS");
        moonParam.setRelationshipDirection("INCOMING");
        moonParam.setBooleanOperator(BooleanOperator.OR);
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(planetParam).add(moonParam), 1).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) MATCH (m0:`Planet`) WHERE m0.`name` = { `collidesWith_name` } OPTIONAL MATCH (m1:`Moon`) WHERE m1.`name` = { `moon_name` } OPTIONAL MATCH (n)-[:`COLLIDES`]->(m0) OPTIONAL MATCH (n)<-[:`ORBITS`]-(m1) WITH n MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
    }

    @Test
    public void testFindByMultipleNestedPropertiesAnded() {
        Filter planetParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"Earth");
        planetParam.setNestedPropertyName("collidesWith");
        planetParam.setNestedEntityTypeLabel("Planet");
        planetParam.setRelationshipType("COLLIDES");
        planetParam.setRelationshipDirection("OUTGOING");
        Filter moonParam = new Filter("size", ComparisonOperator.EQUALS, (Object)"5");
        moonParam.setNestedPropertyName("collidesWith");
        moonParam.setNestedEntityTypeLabel("Planet");
        moonParam.setRelationshipType("COLLIDES");
        moonParam.setRelationshipDirection("OUTGOING");
        moonParam.setBooleanOperator(BooleanOperator.AND);
        Assertions.assertThat((String)this.queryStatements.findByType("Asteroid", new Filters().add(planetParam).add(moonParam), 1).getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) MATCH (m0:`Planet`) WHERE m0.`name` = { `collidesWith_name_0` } AND m0.`size` = { `collidesWith_size_1` } MATCH (n)-[:`COLLIDES`]->(m0) WITH DISTINCT n MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
    }

    @Test(expected=MissingOperatorException.class)
    public void testFindByMultipleAndPropertiesWithMissingBooleanOperator() {
        Filter nameParam = new Filter("name", ComparisonOperator.EQUALS, (Object)"AST-1");
        Filter diameterParam = new Filter("diameter", ComparisonOperator.LESS_THAN, (Object)60);
        this.queryStatements.findByType("Asteroid", new Filters().add(nameParam).add(diameterParam), 2).getStatement();
    }
}

