/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.config.ObjectMapperFactory;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.CypherQuery;
import org.neo4j.ogm.cypher.query.PagingAndSortingQuery;
import org.neo4j.ogm.session.request.strategy.impl.NodeDeleteStatements;
import org.neo4j.ogm.session.request.strategy.impl.NodeQueryStatements;
import org.neo4j.ogm.session.request.strategy.impl.RelationshipDeleteStatements;
import org.neo4j.ogm.session.request.strategy.impl.RelationshipQueryStatements;

public class ParameterisedStatementTest {
    private static final ObjectMapper mapper = ObjectMapperFactory.objectMapper();
    private NodeQueryStatements nodeQueryStatements = new NodeQueryStatements();
    private PagingAndSortingQuery query;
    private CypherQuery cypherQuery;

    @Test
    public void testFindOne() throws Exception {
        this.query = this.nodeQueryStatements.findOne((Serializable)Long.valueOf(123L), 1);
        Assertions.assertThat((String)this.query.getStatement()).isEqualTo((Object)"MATCH (n) WHERE ID(n) = { id } WITH n MATCH p=(n)-[*0..1]-(m) RETURN p");
        Assertions.assertThat((String)mapper.writeValueAsString((Object)this.query.getParameters())).isEqualTo((Object)"{\"id\":123}");
    }

    @Test
    public void testFindByLabel() throws Exception {
        this.query = this.nodeQueryStatements.findByType("NODE", 1);
        Assertions.assertThat((String)this.query.getStatement()).isEqualTo((Object)"MATCH (n:`NODE`) WITH n MATCH p=(n)-[*0..1]-(m) RETURN p");
        Assertions.assertThat((String)mapper.writeValueAsString((Object)this.query.getParameters())).isEqualTo((Object)"{}");
    }

    @Test
    public void testFindByTypeWithIllegalCharacter() throws Exception {
        this.query = new RelationshipQueryStatements().findByType("HAS-ALBUM", 1);
        Assertions.assertThat((String)this.query.getStatement()).isEqualTo((Object)"MATCH ()-[r0:`HAS-ALBUM`]-()  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m MATCH p1 = (n)-[*0..1]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..1]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
        Assertions.assertThat((String)mapper.writeValueAsString((Object)this.query.getParameters())).isEqualTo((Object)"{}");
    }

    @Test
    public void findByPropertyStringValue() throws Exception {
        this.query = this.nodeQueryStatements.findByType("Asteroid", new Filters().add(new Filter("ref", ComparisonOperator.EQUALS, (Object)"45 Eugenia")), 1);
        Assertions.assertThat((String)this.query.getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`ref` = { `ref_0` } WITH n MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
        Assertions.assertThat((String)mapper.writeValueAsString((Object)this.query.getParameters())).isEqualTo((Object)"{\"ref_0\":\"45 Eugenia\"}");
    }

    @Test
    public void findByPropertyWildcardLike() throws JsonProcessingException {
        Filter filter = new Filter("ref", ComparisonOperator.LIKE, (Object)"*nia");
        this.query = this.nodeQueryStatements.findByType("Asteroid", new Filters().add(filter), 1);
        Assertions.assertThat((String)mapper.writeValueAsString((Object)this.query.getParameters())).isEqualTo((Object)"{\"ref_0\":\"(?i).*nia\"}");
    }

    @Test
    public void findByPropertyIntegralValue() throws Exception {
        this.query = this.nodeQueryStatements.findByType("Asteroid", new Filters().add(new Filter("index", ComparisonOperator.EQUALS, (Object)77)), 1);
        Assertions.assertThat((String)this.query.getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`index` = { `index_0` } WITH n MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
        Assertions.assertThat((String)mapper.writeValueAsString((Object)this.query.getParameters())).isEqualTo((Object)"{\"index_0\":77}");
    }

    @Test
    public void findByPropertyStandardForm() throws Exception {
        this.query = this.nodeQueryStatements.findByType("Asteroid", new Filters().add(new Filter("diameter", ComparisonOperator.EQUALS, (Object)60.2)), 1);
        Assertions.assertThat((String)this.query.getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`diameter` = { `diameter_0` } WITH n MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
        Assertions.assertThat((String)mapper.writeValueAsString((Object)this.query.getParameters())).isEqualTo((Object)"{\"diameter_0\":60.2}");
    }

    @Test
    public void findByPropertyDecimal() throws Exception {
        this.query = this.nodeQueryStatements.findByType("Asteroid", new Filters().add(new Filter("diameter", ComparisonOperator.EQUALS, (Object)60.2)), 1);
        Assertions.assertThat((String)this.query.getStatement()).isEqualTo((Object)"MATCH (n:`Asteroid`) WHERE n.`diameter` = { `diameter_0` } WITH n MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
        Assertions.assertThat((String)mapper.writeValueAsString((Object)this.query.getParameters())).isEqualTo((Object)"{\"diameter_0\":60.2}");
    }

    @Test
    public void findByPropertyEmbeddedDelimiter() throws Exception {
        this.query = this.nodeQueryStatements.findByType("Cookbooks", new Filters().add(new Filter("title", ComparisonOperator.EQUALS, (Object)"Mrs Beeton's Household Recipes")), 1);
        Assertions.assertThat((String)this.query.getStatement()).isEqualTo((Object)"MATCH (n:`Cookbooks`) WHERE n.`title` = { `title_0` } WITH n MATCH p=(n)-[*0..1]-(m) RETURN p, ID(n)");
        Assertions.assertThat((String)mapper.writeValueAsString((Object)this.query.getParameters())).isEqualTo((Object)"{\"title_0\":\"Mrs Beeton's Household Recipes\"}");
    }

    @Test
    public void delete() throws Exception {
        this.cypherQuery = new NodeDeleteStatements().delete(Long.valueOf(123L));
        Assertions.assertThat((String)this.cypherQuery.getStatement()).isEqualTo((Object)"MATCH (n) WHERE ID(n) = { id } OPTIONAL MATCH (n)-[r0]-() DELETE r0, n");
        Assertions.assertThat((String)mapper.writeValueAsString((Object)this.cypherQuery.getParameters())).isEqualTo((Object)"{\"id\":123}");
    }

    @Test
    public void deleteAll() throws Exception {
        List<Long> ids = Arrays.asList(123L, 234L, 345L);
        this.cypherQuery = new NodeDeleteStatements().delete(ids);
        Assertions.assertThat((String)this.cypherQuery.getStatement()).isEqualTo((Object)"MATCH (n) WHERE ID(n) in { ids } OPTIONAL MATCH (n)-[r0]-() DELETE r0, n");
        Assertions.assertThat((String)mapper.writeValueAsString((Object)this.cypherQuery.getParameters())).isEqualTo((Object)"{\"ids\":[123,234,345]}");
    }

    @Test
    public void deleteAllByLabel() throws Exception {
        this.cypherQuery = new NodeDeleteStatements().delete("NODE");
        Assertions.assertThat((String)this.cypherQuery.getStatement()).isEqualTo((Object)"MATCH (n:`NODE`) OPTIONAL MATCH (n)-[r0]-() DELETE r0, n");
        Assertions.assertThat((String)mapper.writeValueAsString((Object)this.cypherQuery.getParameters())).isEqualTo((Object)"{}");
    }

    @Test
    public void purge() throws Exception {
        this.cypherQuery = new NodeDeleteStatements().deleteAll();
        Assertions.assertThat((String)this.cypherQuery.getStatement()).isEqualTo((Object)"MATCH (n) OPTIONAL MATCH (n)-[r0]-() DELETE r0, n");
        Assertions.assertThat((String)mapper.writeValueAsString((Object)this.cypherQuery.getParameters())).isEqualTo((Object)"{}");
    }

    @Test
    public void deleteRel() throws Exception {
        this.cypherQuery = new RelationshipDeleteStatements().delete(Long.valueOf(123L));
        Assertions.assertThat((String)this.cypherQuery.getStatement()).isEqualTo((Object)"MATCH (n)-[r0]->() WHERE ID(r0) = { id } DELETE r0");
        Assertions.assertThat((String)mapper.writeValueAsString((Object)this.cypherQuery.getParameters())).isEqualTo((Object)"{\"id\":123}");
    }

    @Test
    public void deleteAllRels() throws Exception {
        List<Long> ids = Arrays.asList(123L, 234L, 345L);
        this.cypherQuery = new RelationshipDeleteStatements().delete(ids);
        Assertions.assertThat((String)this.cypherQuery.getStatement()).isEqualTo((Object)"MATCH (n)-[r0]->() WHERE ID(r0) IN { ids } DELETE r0");
        Assertions.assertThat((String)mapper.writeValueAsString((Object)this.cypherQuery.getParameters())).isEqualTo((Object)"{\"ids\":[123,234,345]}");
    }

    @Test
    public void deleteAllRelsByType() throws Exception {
        this.cypherQuery = new RelationshipDeleteStatements().delete("REL");
        Assertions.assertThat((String)this.cypherQuery.getStatement()).isEqualTo((Object)"MATCH (n)-[r0:`REL`]-() DELETE r0");
        Assertions.assertThat((String)mapper.writeValueAsString((Object)this.cypherQuery.getParameters())).isEqualTo((Object)"{}");
    }

    @Test
    public void testFindByPropertyWithIllegalCharacter() throws Exception {
        this.query = new RelationshipQueryStatements().findByType("HAS-ALBUM", new Filters().add(new Filter("fake-property", ComparisonOperator.EQUALS, (Object)"none")), 1);
        Assertions.assertThat((String)this.query.getStatement()).isEqualTo((Object)"MATCH (n)-[r0:`HAS-ALBUM`]->(m) WHERE r0.`fake-property` = { `fake-property_0` }  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m MATCH p1 = (n)-[*0..1]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..1]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
        Assertions.assertThat((String)mapper.writeValueAsString((Object)this.query.getParameters())).isEqualTo((Object)"{\"fake-property_0\":\"none\"}");
    }
}

