/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy.impl;

import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.CypherQuery;
import org.neo4j.ogm.session.request.strategy.DeleteStatements;
import org.neo4j.ogm.session.request.strategy.impl.RelationshipDeleteStatements;

public class RelationshipDeleteStatementsTest {
    private final DeleteStatements statements = new RelationshipDeleteStatements();

    @Test
    public void testDeleteOne() throws Exception {
        Assertions.assertThat((String)this.statements.delete(Long.valueOf(0L)).getStatement()).isEqualTo((Object)"MATCH (n)-[r0]->() WHERE ID(r0) = { id } DELETE r0");
    }

    @Test
    public void testDeleteMany() throws Exception {
        Assertions.assertThat((String)this.statements.delete(Arrays.asList(1L, 2L)).getStatement()).isEqualTo((Object)"MATCH (n)-[r0]->() WHERE ID(r0) IN { ids } DELETE r0");
    }

    @Test
    public void testDeleteAll() throws Exception {
        Assertions.assertThat((String)this.statements.deleteAll().getStatement()).isEqualTo((Object)"MATCH (n) OPTIONAL MATCH (n)-[r0]-() DELETE r0");
    }

    @Test
    public void testDeleteWithType() throws Exception {
        Assertions.assertThat((String)this.statements.delete("TRAFFIC_WARDEN").getStatement()).isEqualTo((Object)"MATCH (n)-[r0:`TRAFFIC_WARDEN`]-() DELETE r0");
    }

    @Test
    public void testDeleteWithTypeAndFilters() throws Exception {
        CypherQuery query = this.statements.delete("INFLUENCE", (Iterable)new Filters().add(new Filter("score", ComparisonOperator.EQUALS, (Object)-12.2)));
        Assertions.assertThat((String)query.getStatement()).isEqualTo((Object)"MATCH (n)-[r0:`INFLUENCE`]->(m) WHERE r0.`score` = { `score_0` }  DELETE r0");
    }

    @Test
    public void testDeleteWithTypeAndFiltersAndList() throws Exception {
        CypherQuery query = this.statements.deleteAndList("INFLUENCE", (Iterable)new Filters().add(new Filter("score", ComparisonOperator.EQUALS, (Object)-12.2)));
        Assertions.assertThat((String)query.getStatement()).isEqualTo((Object)"MATCH (n)-[r0:`INFLUENCE`]->(m) WHERE r0.`score` = { `score_0` }  DELETE r0 RETURN ID(r0)");
    }
}

