/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy.impl;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.metadata.DomainInfo;
import org.neo4j.ogm.metadata.schema.DomainInfoSchemaBuilder;
import org.neo4j.ogm.metadata.schema.Schema;
import org.neo4j.ogm.session.request.strategy.impl.SchemaNodeLoadClauseBuilder;

public class SchemaNodeLoadClauseBuilderTest {
    @Test
    public void buildQuery() {
        SchemaNodeLoadClauseBuilder queryBuilder = this.createQueryBuilder();
        String query = queryBuilder.build("n", "Person", 0);
        Assertions.assertThat((String)query).isEqualTo((Object)" RETURN n");
    }

    @Test
    public void buildQueryFromLocation() {
        SchemaNodeLoadClauseBuilder queryBuilder = this.createQueryBuilder();
        String query = queryBuilder.build("n", "Location", 1);
        Assertions.assertThat((String)query).isEqualTo((Object)" RETURN n,[ [ (n)<-[r_l1:`LIVES_AT`]-(p1:`Person`) | [ r_l1, p1 ] ] ]");
    }

    @Test
    public void buildQueryFromPerson() {
        SchemaNodeLoadClauseBuilder queryBuilder = this.createQueryBuilder();
        String query = queryBuilder.build("n", "Person", 2);
        Assertions.assertThat((String)query).isEqualTo((Object)" RETURN n,[ [ (n)-[r_f1:`FOUNDED`]->(o1:`Organisation`) | [ r_f1, o1 ] ], [ (n)-[r_e1:`EMPLOYED_BY`]->(o1:`Organisation`) | [ r_e1, o1 ] ], [ (n)-[r_l1:`LIVES_AT`]->(l1:`Location`) | [ r_l1, l1, [ [ (l1)<-[r_l2:`LIVES_AT`]-(p2:`Person`) | [ r_l2, p2 ] ] ] ] ] ]");
    }

    @Test
    public void givenNodeWithNoRelationships_thenCreateSimpleQuery() {
        SchemaNodeLoadClauseBuilder queryBuilder = this.createQueryBuilder();
        String query = queryBuilder.build("n", "Organisation", 1);
        Assertions.assertThat((String)query).isEqualTo((Object)" RETURN n");
    }

    @Test
    public void givenLabelStartingWithR_thenNodeNameAndrelationshipNameShouldNotConflict() {
        SchemaNodeLoadClauseBuilder queryBuilder = this.createQueryBuilder();
        String query = queryBuilder.build("n", "Restaurant", 1);
        Assertions.assertThat((String)query).isEqualTo((Object)" RETURN n,[ [ (n)-[r_s1:`SIMILAR_TO`]->(r1:`Restaurant`) | [ r_s1, r1 ] ] ]");
    }

    @Test
    public void shouldMatchRelationshipForAllPossibleMappings() {
        DomainInfo domainInfo = DomainInfo.create((String[])new String[]{"org.neo4j.ogm.domain.gh670"});
        Schema schema = new DomainInfoSchemaBuilder(domainInfo).build();
        SchemaNodeLoadClauseBuilder builder = new SchemaNodeLoadClauseBuilder(schema);
        String query = builder.build("n", "Person", 1);
        Assertions.assertThat((String)query).isEqualTo((Object)" RETURN n,[ [ (n)-[r_c1:`COURCES`]-(c1:`Course`) | [ r_c1, c1 ] ], [ (n)-[r_t1:`TAKES`]->(c1:`Course`) | [ r_t1, c1 ] ], [ (n)<-[r_t1:`TAUGHT_BY`]-(t1:`Teacher`) | [ r_t1, t1 ] ], [ (n)-[r_f1:`FRIENDS`]-(p1:`Pupil`) | [ r_f1, p1 ] ] ]");
        query = builder.build("n", "Pupil", 1);
        Assertions.assertThat((String)query).isEqualTo((Object)" RETURN n,[ [ (n)-[r_t1:`TAKES`]->(c1:`Course`) | [ r_t1, c1 ] ], [ (n)<-[r_t1:`TAUGHT_BY`]-(t1:`Teacher`) | [ r_t1, t1 ] ], [ (n)-[r_f1:`FRIENDS`]-(p1:`Pupil`) | [ r_f1, p1 ] ] ]");
        query = builder.build("n", "Klassenclown", 1);
        Assertions.assertThat((String)query).isEqualTo((Object)" RETURN n,[ [ (n)-[r_t1:`TAKES`]->(c1:`Course`) | [ r_t1, c1 ] ], [ (n)<-[r_t1:`TAUGHT_BY`]-(t1:`Teacher`) | [ r_t1, t1 ] ], [ (n)-[r_f1:`FRIENDS`]-(p1:`Pupil`) | [ r_f1, p1 ] ] ]");
        query = builder.build("n", "Teacher", 1);
        Assertions.assertThat((String)query).isEqualTo((Object)" RETURN n,[ [ (n)-[r_c1:`COURCES`]-(c1:`Course`) | [ r_c1, c1 ] ] ]");
        query = builder.build("n", "Teacher", 3);
        Assertions.assertThat((String)query).isEqualTo((Object)" RETURN n,[ [ (n)-[r_c1:`COURCES`]-(c1:`Course`) | [ r_c1, c1, [ [ (c1)<-[r_t2:`TAKES`]-(p2:`Pupil`) | [ r_t2, p2, [ [ (p2)-[r_t3:`TAKES`]->(c3:`Course`) | [ r_t3, c3 ] ], [ (p2)<-[r_t3:`TAUGHT_BY`]-(t3:`Teacher`) | [ r_t3, t3 ] ], [ (p2)-[r_f3:`FRIENDS`]-(p3:`Pupil`) | [ r_f3, p3 ] ] ] ] ] ] ] ] ]");
    }

    private SchemaNodeLoadClauseBuilder createQueryBuilder() {
        DomainInfo domainInfo = DomainInfo.create((String[])new String[]{"org.neo4j.ogm.domain.simple"});
        Schema schema = new DomainInfoSchemaBuilder(domainInfo).build();
        return new SchemaNodeLoadClauseBuilder(schema);
    }
}

