/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy.impl;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.metadata.DomainInfo;
import org.neo4j.ogm.metadata.schema.DomainInfoSchemaBuilder;
import org.neo4j.ogm.metadata.schema.Schema;
import org.neo4j.ogm.session.request.strategy.impl.SchemaRelationshipLoadClauseBuilder;

public class SchemaRelationshipLoadClauseBuilderTest {
    private SchemaRelationshipLoadClauseBuilder builder;

    @Before
    public void setUp() {
        this.builder = this.createLoadClauseBuilder();
    }

    @Test(expected=IllegalArgumentException.class)
    public void buildClauseDepthZeroNotAllowed() {
        this.builder.build("r", "FRIEND_OF", 0);
    }

    @Test
    public void buildClauseWithDepthTwo() {
        String clause = this.builder.build("r", "FOUNDED", 1);
        Assertions.assertThat((String)clause).isEqualToIgnoringWhitespace((CharSequence)" RETURN r,n,[ [ (n)-[r_f1:`FOUNDED`]->(o1:`Organisation`) | [ r_f1, o1 ] ],[ (n)-[r_e1:`EMPLOYED_BY`]->(o1:`Organisation`) | [ r_e1, o1 ] ],[ (n)-[r_l1:`LIVES_AT`]->(l1:`Location`) | [ r_l1, l1 ] ] ],m");
    }

    private SchemaRelationshipLoadClauseBuilder createLoadClauseBuilder() {
        DomainInfo domainInfo = DomainInfo.create((String[])new String[]{"org.neo4j.ogm.domain.simple"});
        Schema schema = new DomainInfoSchemaBuilder(domainInfo).build();
        return new SchemaRelationshipLoadClauseBuilder(schema);
    }
}

