/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.support;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.support.ClassUtils;

public class ClassUtilsTest {
    @Test
    public void shouldWorkWithPlainEnum() {
        Assertions.assertThat((boolean)ClassUtils.isEnum(YourFriendlyEnumMostPeopleUse.class)).isTrue();
        Assertions.assertThat((boolean)ClassUtils.isEnum((Object)((Object)YourFriendlyEnumMostPeopleUse.THING1))).isTrue();
        Assertions.assertThat((boolean)ClassUtils.isEnum((Object)((Object)YourFriendlyEnumMostPeopleUse.THING2))).isTrue();
    }

    @Test
    public void shouldWorkWithExtendedEnum() {
        Assertions.assertThat((boolean)ClassUtils.isEnum(YesEnumsCanBeMuchMore.class)).isTrue();
        Assertions.assertThat((boolean)ClassUtils.isEnum((Object)((Object)YesEnumsCanBeMuchMore.THING1))).isTrue();
        Assertions.assertThat((boolean)ClassUtils.isEnum((Object)((Object)YesEnumsCanBeMuchMore.THING2))).isTrue();
    }

    @Test
    public void shouldWorkWithInterfaceEnum() {
        Assertions.assertThat((boolean)ClassUtils.isEnum(Singleton.class)).isTrue();
        Assertions.assertThat((boolean)ClassUtils.isEnum((Object)Singleton.THE_INSTANCE)).isTrue();
    }

    static enum Singleton implements SomeInterface
    {
        THE_INSTANCE;

    }

    static interface SomeInterface {
    }

    static enum YesEnumsCanBeMuchMore {
        THING1,
        THING2{

            @Override
            public void something() {
            }
        };


        void something() {
        }
    }

    static enum YourFriendlyEnumMostPeopleUse {
        THING1,
        THING2;

    }
}

