/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.domain.convertible.enums.Algebra;
import org.neo4j.ogm.domain.convertible.enums.Education;
import org.neo4j.ogm.domain.convertible.enums.Gender;
import org.neo4j.ogm.domain.convertible.enums.NumberSystem;
import org.neo4j.ogm.domain.convertible.enums.Person;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class EnumConversionTest {
    private static final MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.convertible.enums"});
    private static final ClassInfo algebraInfo = metaData.classInfo("Algebra");
    private static final ClassInfo personInfo = metaData.classInfo("Person");
    private static final ClassInfo tagEntityInfo = metaData.classInfo("TagEntity");

    @Test
    public void testSaveFieldWithAnnotatedConverter() {
        FieldInfo fieldInfo = algebraInfo.propertyField("numberSystem");
        Assertions.assertThat((boolean)fieldInfo.hasPropertyConverter()).isTrue();
        Algebra algebra = new Algebra();
        algebra.setNumberSystem(NumberSystem.NATURAL);
        Assertions.assertThat((String)algebra.getNumberSystem().getDomain()).isEqualTo((Object)"N");
        String value = (String)fieldInfo.getPropertyConverter().toGraphProperty((Object)algebra.getNumberSystem());
        Assertions.assertThat((String)value).isEqualTo((Object)"NATURAL");
    }

    @Test
    public void testLoadFieldWithAnnotatedConverter() {
        FieldInfo fieldInfo = algebraInfo.propertyField("numberSystem");
        Assertions.assertThat((boolean)fieldInfo.hasPropertyConverter()).isTrue();
        String value = "INTEGER";
        Algebra algebra = new Algebra();
        algebra.setNumberSystem((NumberSystem)((Object)fieldInfo.getPropertyConverter().toEntityAttribute((Object)value)));
        Assertions.assertThat((Comparable)((Object)algebra.getNumberSystem())).isEqualTo((Object)NumberSystem.INTEGER);
        Assertions.assertThat((String)algebra.getNumberSystem().getDomain()).isEqualTo((Object)"Z");
    }

    @Test
    public void testGenderFieldWithAutoDetectedConverter() {
        Person bob = new Person();
        bob.setGender(Gender.MALE);
        FieldInfo fieldInfo = personInfo.propertyField("gender");
        Assertions.assertThat((boolean)fieldInfo.hasPropertyConverter()).isTrue();
        Assertions.assertThat((Object)fieldInfo.getPropertyConverter().toGraphProperty((Object)bob.getGender())).isEqualTo((Object)"MALE");
    }

    @Test
    public void assertConvertingNullGraphPropertyWorksCorrectly() {
        FieldInfo methodInfo = personInfo.propertyField("gender");
        Assertions.assertThat((boolean)methodInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = methodInfo.getPropertyConverter();
        Assertions.assertThat((Object)attributeConverter.toEntityAttribute(null)).isEqualTo(null);
    }

    @Test
    public void assertConvertingNullAttributeWorksCorrectly() {
        FieldInfo methodInfo = personInfo.propertyField("gender");
        Assertions.assertThat((boolean)methodInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = methodInfo.getPropertyConverter();
        Assertions.assertThat((Object)attributeConverter.toGraphProperty(null)).isEqualTo(null);
    }

    @Test
    public void testEducationArrayFieldWithAutoDetectedConverter() {
        Person bob = new Person();
        bob.setGender(Gender.MALE);
        Education[] inProgress = new Education[]{Education.MASTERS, Education.PHD};
        bob.setInProgressEducation(inProgress);
        FieldInfo fieldInfo = personInfo.propertyField("inProgressEducation");
        Assertions.assertThat((boolean)fieldInfo.hasPropertyConverter()).isTrue();
        String[] converted = (String[])fieldInfo.getPropertyConverter().toGraphProperty((Object)bob.getInProgressEducation());
        Assertions.assertThat(("MASTERS".equals(converted[0]) || "MASTERS".equals(converted[1]) ? 1 : 0) != 0).isTrue();
        Assertions.assertThat(("PHD".equals(converted[0]) || "PHD".equals(converted[1]) ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void assertConvertingNullArrayGraphPropertyWorksCorrectly() {
        FieldInfo methodInfo = personInfo.propertyField("inProgressEducation");
        Assertions.assertThat((boolean)methodInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = methodInfo.getPropertyConverter();
        Assertions.assertThat((Object)attributeConverter.toEntityAttribute(null)).isEqualTo(null);
    }

    @Test
    public void assertConvertingNullArrayAttributeWorksCorrectly() {
        FieldInfo methodInfo = personInfo.propertyField("inProgressEducation");
        Assertions.assertThat((boolean)methodInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = methodInfo.getPropertyConverter();
        Assertions.assertThat((Object)attributeConverter.toGraphProperty(null)).isEqualTo(null);
    }

    @Test
    public void testEducationCollectionFieldWithAutoDetectedConverter() {
        ArrayList<Education> completedEducation = new ArrayList<Education>();
        completedEducation.add(Education.HIGHSCHOOL);
        completedEducation.add(Education.BACHELORS);
        Person bob = new Person();
        bob.setCompletedEducation(completedEducation);
        FieldInfo fieldInfo = personInfo.propertyField("completedEducation");
        Assertions.assertThat((boolean)fieldInfo.hasPropertyConverter()).isTrue();
        String[] converted = (String[])fieldInfo.getPropertyConverter().toGraphProperty(bob.getCompletedEducation());
        Assertions.assertThat(("HIGHSCHOOL".equals(converted[0]) || "HIGHSCHOOL".equals(converted[1]) ? 1 : 0) != 0).isTrue();
        Assertions.assertThat(("BACHELORS".equals(converted[0]) || "BACHELORS".equals(converted[1]) ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void assertConvertingNullCollectionGraphPropertyWorksCorrectly() {
        FieldInfo methodInfo = personInfo.propertyField("completedEducation");
        Assertions.assertThat((boolean)methodInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = methodInfo.getPropertyConverter();
        Assertions.assertThat((Object)attributeConverter.toEntityAttribute(null)).isEqualTo(null);
    }

    @Test
    public void assertConvertingNullCollectionAttributeWorksCorrectly() {
        FieldInfo methodInfo = personInfo.propertyField("completedEducation");
        Assertions.assertThat((boolean)methodInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = methodInfo.getPropertyConverter();
        Assertions.assertThat((Object)attributeConverter.toGraphProperty(null)).isEqualTo(null);
    }

    @Test
    public void shouldNotRegisterEnumWhenTypeContainsEnumType() {
        FieldInfo fieldInfo = tagEntityInfo.relationshipFieldByName("tags");
        Assertions.assertThat((boolean)fieldInfo.hasPropertyConverter()).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailOnEmptyGraphProperty() {
        FieldInfo fieldInfo = algebraInfo.propertyField("operation");
        Assertions.assertThat((boolean)fieldInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = fieldInfo.getPropertyConverter();
        Assertions.assertThat((Object)attributeConverter.toEntityAttribute((Object)"")).isNull();
    }

    @Test
    public void shouldWorkOnEmptyGraphPropertyWithLenientConversionEnabled() {
        FieldInfo fieldInfo = algebraInfo.propertyField("operationLenient");
        Assertions.assertThat((boolean)fieldInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = fieldInfo.getPropertyConverter();
        Assertions.assertThat((Object)attributeConverter.toEntityAttribute((Object)"")).isNull();
    }
}

