/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.io.Serializable;
import java.net.URI;
import org.assertj.core.api.AbstractLongArrayAssert;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilders;
import org.neo4j.ogm.domain.gh492.BaseUser;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;

public class GenericArrayConversionTest {
    protected static final String DOMAIN_PACKAGE = "org.neo4j.ogm.domain.gh492";
    protected static ServerControls serverControls;
    protected static SessionFactory sessionFactory;
    protected static boolean supportsBytePacking;

    @BeforeClass
    public static void startServer() {
        serverControls = TestServerBuilders.newInProcessBuilder().newServer();
        org.neo4j.driver.v1.Driver driver = GraphDatabase.driver((URI)serverControls.boltURI(), (Config)Config.build().withoutEncryption().toConfig());
        supportsBytePacking = ServerVersion.version((org.neo4j.driver.v1.Driver)driver).greaterThanOrEqual(ServerVersion.v3_2_0);
        sessionFactory = new SessionFactory((Driver)new BoltDriver(driver), new String[]{DOMAIN_PACKAGE});
    }

    @Test
    public void byteSampleTest() {
        Assume.assumeTrue((boolean)supportsBytePacking);
        BaseUser.ByteUser byteUser = new BaseUser.ByteUser();
        byteUser.setLoginName("test-byteUser");
        byteUser.setGenericValue(new byte[]{0, 1, 2, 3, 4, 5, 6, 7});
        byteUser.setNotGenericValue(new byte[]{7, 6, 5, 4, 3, 2, 1, 0});
        Session session = sessionFactory.openSession();
        session.save((Object)byteUser);
        session.clear();
        byteUser = (BaseUser.ByteUser)session.load(BaseUser.ByteUser.class, (Serializable)byteUser.getId());
        Assertions.assertThat((byte[])byteUser.getNotGenericValue()).isInstanceOf(byte[].class);
        Assertions.assertThat((byte[])((byte[])byteUser.getGenericValue())).isInstanceOf(byte[].class);
    }

    @Test
    public void intSampleTest() {
        BaseUser.IntUser intUser = new BaseUser.IntUser();
        intUser.setLoginName("test-intUser");
        intUser.setGenericValue(new int[]{0, 1, 2, 3, 4, 5, 6, 7});
        Session session = sessionFactory.openSession();
        session.save((Object)intUser);
        session.clear();
        intUser = (BaseUser.IntUser)session.load(BaseUser.IntUser.class, (Serializable)intUser.getId());
        Assertions.assertThat((int[])((int[])intUser.getGenericValue())).isInstanceOf(int[].class);
    }

    @Test
    public void integerSampleTest() {
        BaseUser.IntegerUser integerUser = new BaseUser.IntegerUser();
        integerUser.setLoginName("test-intUser");
        integerUser.setGenericValue(new Integer[]{Integer.MIN_VALUE, Integer.MAX_VALUE});
        Session session = sessionFactory.openSession();
        session.save((Object)integerUser);
        session.clear();
        integerUser = (BaseUser.IntegerUser)session.load(BaseUser.IntegerUser.class, (Serializable)integerUser.getId());
        ((AbstractObjectArrayAssert)Assertions.assertThat((Object[])((Object[])integerUser.getGenericValue())).isInstanceOf(Integer[].class)).containsExactly((Object[])new Integer[]{Integer.MIN_VALUE, Integer.MAX_VALUE});
    }

    @Test
    public void longSampleTest() {
        BaseUser.LongUser longUser = new BaseUser.LongUser();
        longUser.setLoginName("test-intUser");
        longUser.setGenericValue(new long[]{Long.MIN_VALUE, Long.MAX_VALUE});
        Session session = sessionFactory.openSession();
        session.save((Object)longUser);
        session.clear();
        longUser = (BaseUser.LongUser)session.load(BaseUser.LongUser.class, (Serializable)longUser.getId());
        ((AbstractLongArrayAssert)Assertions.assertThat((long[])((long[])longUser.getGenericValue())).isInstanceOf(long[].class)).containsExactly(new long[]{Long.MIN_VALUE, Long.MAX_VALUE});
    }

    @Test
    public void stringSampleTest() {
        BaseUser.StringUser stringUser = new BaseUser.StringUser();
        stringUser.setLoginName("test-stringUser");
        stringUser.setGenericValue(new String[]{"1", "2", "3", "4", "5", "6", "7"});
        Session session = sessionFactory.openSession();
        session.save((Object)stringUser);
        session.clear();
        stringUser = (BaseUser.StringUser)session.load(BaseUser.StringUser.class, (Serializable)stringUser.getId());
        Assertions.assertThat((Object[])((Object[])stringUser.getGenericValue())).isInstanceOf(String[].class);
    }

    @AfterClass
    public static void stopServer() {
        sessionFactory.close();
        serverControls.close();
    }

    static {
        supportsBytePacking = false;
    }
}

