/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.ogm.domain.music.Album;
import org.neo4j.ogm.domain.music.Artist;
import org.neo4j.ogm.domain.music.TimeHolder;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class TypeConversionIntegrationTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.music"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
    }

    @After
    public void clear() {
        this.session.purgeDatabase();
    }

    @Test
    public void convertibleReturnTypesShouldBeHandled() {
        ZoneId utc = ZoneId.of("UTC");
        Artist queen = new Artist("Queen");
        Album album = new Album("Queen");
        album.setArtist(queen);
        album.setRecordedAt(Date.from(LocalDate.of(1972, 11, 30).atStartOfDay(utc).toInstant()));
        album.setReleased(Date.from(LocalDate.of(1973, 7, 13).atStartOfDay(utc).toInstant()));
        album = new Album("Queen II");
        album.setArtist(queen);
        album.setRecordedAt(Date.from(LocalDate.of(1973, 8, 1).atStartOfDay(utc).toInstant()));
        Date queen2ReleaseDate = Date.from(LocalDate.of(1974, 3, 8).atStartOfDay(utc).toInstant());
        album.setReleased(queen2ReleaseDate);
        this.session.save((Object)album);
        this.session.clear();
        Date latestReleases = (Date)this.session.queryForObject(Date.class, "MATCH (n:`l'album`) RETURN MAX(n.releasedAt)", new HashMap());
        Assertions.assertThat((Date)latestReleases).isEqualTo((Object)queen2ReleaseDate);
    }

    @Test
    public void savedTimestampAsMappingIsReadBackAsIs() {
        OffsetDateTime someTime = OffsetDateTime.parse("2024-05-01T21:18:15.650+07:00");
        LocalDateTime someLocalDateTime = LocalDateTime.parse("2024-05-01T21:18:15");
        LocalDate someLocalDate = LocalDate.parse("2024-05-01");
        TimeHolder timeHolder = new TimeHolder();
        timeHolder.setSomeTime(someTime);
        timeHolder.setSomeLocalDateTime(someLocalDateTime);
        timeHolder.setSomeLocalDate(someLocalDate);
        this.session.save((Object)timeHolder);
        this.verify(timeHolder.getGraphId(), someTime, someLocalDateTime, someLocalDate);
    }

    @Test
    public void savedTimestampAsParameterToBatchedCreateIsReadBackAsIs() {
        String someTimeStringValue = "2024-05-01T21:18:15.65+07:00";
        OffsetDateTime someTime = OffsetDateTime.parse(someTimeStringValue);
        String someLocalDateTimeStringValue = "2024-05-01T21:18:15";
        LocalDateTime someLocalDateTime = LocalDateTime.parse(someLocalDateTimeStringValue);
        String someLocalDateStringValue = "2024-05-01";
        LocalDate someLocalDate = LocalDate.parse(someLocalDateStringValue);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("someTime", someTimeStringValue);
        props.put("someLocalDateTime", someLocalDateTimeStringValue);
        props.put("someLocalDate", someLocalDateStringValue);
        HashMap<String, Serializable> row = new HashMap<String, Serializable>();
        row.put("nodeRef", Integer.valueOf(-1));
        row.put("props", props);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("type", "node");
        parameters.put("rows", Collections.singletonList(row));
        Result result = this.session.query("UNWIND {rows} AS row CREATE (n:`Data`) SET n=row.props RETURN row.nodeRef AS ref, id(n) AS id, {type} AS type", parameters);
        this.verify((Long)((Map)((Iterable)result.queryResults()).iterator().next()).get("id"), someTime, someLocalDateTime, someLocalDate);
    }

    @Test
    public void dataStoredInNotRealIsoFormatShouldStillBeParsed() {
        OffsetDateTime someTime1 = OffsetDateTime.parse("2024-05-01T21:18:15.650+07:00");
        OffsetDateTime someTime2 = OffsetDateTime.parse("2024-05-01T21:18:15.65+07:00");
        OffsetDateTime someTime3 = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)"2024-05-01T21:18:15.650+07:00", OffsetDateTime::from);
        OffsetDateTime someTime4 = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)"2024-05-01T21:18:15.65+07:00", OffsetDateTime::from);
        Assertions.assertThat((OffsetDateTime)someTime1).isEqualTo((Object)someTime2);
        Assertions.assertThat((OffsetDateTime)someTime2).isEqualTo((Object)someTime3);
        Assertions.assertThat((OffsetDateTime)someTime3).isEqualTo((Object)someTime4);
        String withDifferentMillis = "2024-05-01T21:18:15.651+07:00";
        OffsetDateTime a = OffsetDateTime.parse(withDifferentMillis);
        OffsetDateTime b = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)withDifferentMillis, OffsetDateTime::from);
        Assertions.assertThat((OffsetDateTime)a).isEqualTo((Object)b);
    }

    @Test
    public void savedTimestampAsParameterToSimpleCreateIsReadBackAsIs() {
        String someTimeStringValue = "2024-05-01T21:18:15.65+07:00";
        OffsetDateTime someTime = OffsetDateTime.parse(someTimeStringValue);
        String someLocalDateTimeStringValue = "2024-05-01T21:18:15";
        LocalDateTime someLocalDateTime = LocalDateTime.parse(someLocalDateTimeStringValue);
        String someLocalDateStringValue = "2024-05-01";
        LocalDate someLocalDate = LocalDate.parse(someLocalDateStringValue);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("someTime", someTimeStringValue);
        props.put("someLocalDateTime", someLocalDateTimeStringValue);
        props.put("someLocalDate", someLocalDateStringValue);
        TimeHolder timeHolder = (TimeHolder)this.session.queryForObject(TimeHolder.class, "CREATE (d:Data {someTime: $someTime, someLocalDateTime: $someLocalDateTime, someLocalDate: $someLocalDate}) RETURN d", props);
        this.verify(timeHolder.getGraphId(), someTime, someLocalDateTime, someLocalDate);
    }

    private void verify(Long graphId, OffsetDateTime expectedOffsetDateTime, LocalDateTime expectedLocalDateTime, LocalDate expectedLocalDate) {
        TimeHolder reloaded = (TimeHolder)sessionFactory.openSession().load(TimeHolder.class, (Serializable)graphId);
        Assertions.assertThat((OffsetDateTime)reloaded.getSomeTime()).isEqualTo((Object)expectedOffsetDateTime);
        Assertions.assertThat((LocalDateTime)reloaded.getSomeLocalDateTime()).isEqualTo((Object)expectedLocalDateTime);
        Assertions.assertThat((LocalDate)reloaded.getSomeLocalDate()).isEqualTo((Object)expectedLocalDate);
        String offsetDateTimeValue = null;
        String localDateTimeValue = null;
        String localDateValue = null;
        try (Driver driver = TypeConversionIntegrationTest.getBoltConnection();
             org.neo4j.driver.v1.Session driverSession = driver.session();){
            Record record = driverSession.run("MATCH (n) WHERE id(n) = $id RETURN n", Values.parameters((Object[])new Object[]{"id", graphId})).single();
            Value n = record.get("n");
            offsetDateTimeValue = n.get("someTime").asString();
            localDateTimeValue = n.get("someLocalDateTime").asString();
            localDateValue = n.get("someLocalDate").asString();
        }
        catch (IllegalStateException e) {
            GraphDatabaseService graphDatabaseService = TypeConversionIntegrationTest.getGraphDatabaseService();
            try (Transaction tx = graphDatabaseService.beginTx();){
                Node node = graphDatabaseService.getNodeById(graphId.longValue());
                offsetDateTimeValue = node.getProperty("someTime").toString();
                localDateTimeValue = node.getProperty("someLocalDateTime").toString();
                localDateValue = node.getProperty("someLocalDate").toString();
            }
        }
        String expectedStringValue = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(expectedOffsetDateTime);
        Assertions.assertThat((String)offsetDateTimeValue).isEqualTo((Object)expectedStringValue);
        expectedStringValue = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(expectedLocalDateTime);
        Assertions.assertThat((String)localDateTimeValue).isEqualTo((Object)expectedStringValue);
        expectedStringValue = DateTimeFormatter.ISO_LOCAL_DATE.format(expectedLocalDate);
        Assertions.assertThat((String)localDateValue).isEqualTo((Object)expectedStringValue);
    }
}

