/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.utils;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.domain.pizza.Pizza;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.utils.EntityUtils;

public class EntityUtilsTest {
    private MetaData metaData;

    @Before
    public void setUp() {
        this.metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.pizza"});
    }

    @Test
    public void shouldCollateStaticAndRuntimeLabels() throws Exception {
        Pizza pizza = new Pizza();
        ArrayList<String> labels = new ArrayList<String>();
        labels.add("Delicious");
        labels.add("Hot");
        labels.add("Spicy");
        pizza.setLabels(labels);
        Collection collatedLabels = EntityUtils.labels((Object)pizza, (MetaData)this.metaData);
        Assertions.assertThat((Iterable)collatedLabels).isNotNull();
        Assertions.assertThat((Iterable)collatedLabels).containsOnly((Object[])new String[]{"Delicious", "Hot", "Spicy", "Pizza"});
    }
}

