/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.testutil;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.junit.BeforeClass;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.ogm.config.ClasspathConfigurationSource;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.config.ConfigurationSource;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.drivers.embedded.driver.EmbeddedDriver;
import org.neo4j.ogm.drivers.http.driver.HttpDriver;
import org.neo4j.ogm.exception.core.ConfigurationException;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.FileUtils;
import org.neo4j.ogm.testutil.TestServer;

public class MultiDriverTestClass {
    private static TestServer testServer;
    private static File graphStore;
    private static Configuration.Builder baseConfiguration;
    protected static SessionFactory sessionFactory;
    protected static Driver driver;

    @BeforeClass
    public static void setupMultiDriverTestEnvironment() {
        if (baseConfiguration.build().getDriverClassName().equals(EmbeddedDriver.class.getCanonicalName())) {
            baseConfiguration.uri(graphStore.toURI().toString()).build();
        } else {
            baseConfiguration.uri(testServer.getUri()).credentials(testServer.getUsername(), testServer.getPassword());
        }
        if (driver == null) {
            Configuration configuration = MultiDriverTestClass.getBaseConfiguration().build();
            driver = MultiDriverTestClass.newDriverInstance(configuration.getDriverClassName());
            driver.configure(configuration);
        }
    }

    private static Driver newDriverInstance(String driverClassName) {
        try {
            Class<?> driverClass = Class.forName(driverClassName);
            return (Driver)driverClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new ConfigurationException("Could not load driver class " + driverClassName, (Throwable)e);
        }
    }

    public static Configuration.Builder getBaseConfiguration() {
        return Configuration.Builder.copy((Configuration.Builder)baseConfiguration);
    }

    protected static final org.neo4j.driver.v1.Driver getBoltConnection() {
        if (testServer != null) {
            return GraphDatabase.driver((String)testServer.getUri(), (AuthToken)AuthTokens.none());
        }
        throw new IllegalStateException("Bolt connection can only be provided into a test server.");
    }

    public static GraphDatabaseService getGraphDatabaseService() {
        if (baseConfiguration.build().getURI().startsWith("file")) {
            if (driver != null) {
                return ((EmbeddedDriver)driver).getGraphDatabaseService();
            }
            if (sessionFactory != null) {
                return ((EmbeddedDriver)sessionFactory.getDriver()).getGraphDatabaseService();
            }
        }
        return testServer.getGraphDatabaseService();
    }

    private static File createTemporaryGraphStore() {
        try {
            Path path = Files.createTempDirectory("graph.db", new FileAttribute[0]);
            Path databaseDirectory = Paths.get(path.toFile().getAbsolutePath() + "/database", new String[0]);
            Files.createDirectories(databaseDirectory, new FileAttribute[0]);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    FileUtils.deleteDirectory(path);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to delete temporary files in " + path, e);
                }
            }));
            return path.toFile();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static boolean isEnterpriseEdition() {
        return MultiDriverTestClass.getGraphDatabaseService().getClass().getSimpleName().equals("EnterpriseGraphDatabase");
    }

    protected static boolean isVersionOrGreater(String version) {
        Result result = MultiDriverTestClass.getGraphDatabaseService().execute("CALL dbms.components()");
        Map kernel = result.stream().filter(map -> map.get("name").equals("Neo4j Kernel")).findFirst().orElseThrow(() -> new IllegalStateException("Expected component named 'Neo4j Kernel'"));
        String kernelVersion = (String)((List)kernel.get("versions")).get(0);
        return version.compareTo(kernelVersion) <= 0;
    }

    static {
        String configFileName = System.getenv("ogm.properties");
        if (configFileName == null) {
            configFileName = System.getProperty("ogm.properties");
        }
        if (configFileName == null) {
            configFileName = "ogm.properties";
        }
        if ((baseConfiguration = new Configuration.Builder((ConfigurationSource)new ClasspathConfigurationSource(configFileName))).build().getDriverClassName().equals(HttpDriver.class.getCanonicalName())) {
            testServer = new TestServer(true, false, 5);
        } else if (baseConfiguration.build().getDriverClassName().equals(BoltDriver.class.getCanonicalName())) {
            testServer = new TestServer(true, true, 5);
        } else {
            graphStore = MultiDriverTestClass.createTemporaryGraphStore();
        }
    }
}

