/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.testutil;

import java.net.URI;
import java.util.Arrays;
import java.util.function.Consumer;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilders;
import org.neo4j.ogm.driver.AbstractConfigurableDriver;
import org.neo4j.ogm.session.SessionFactory;

public abstract class SingleDriverTestClass {
    static final Config DRIVER_CONFIG = Config.build().withoutEncryption().toConfig();
    private static ServerControls serverControls;
    private ServerVersion serverVersion;

    @BeforeClass
    public static void initializeNeo4j() {
        serverControls = TestServerBuilders.newInProcessBuilder().newServer();
    }

    public GraphDatabaseService getGraphDatabaseService() {
        return serverControls.graph();
    }

    public Driver getDriver() {
        return GraphDatabase.driver((URI)serverControls.boltURI(), (Config)DRIVER_CONFIG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerVersion getServerVersion() {
        ServerVersion rv = this.serverVersion;
        if (rv == null) {
            SingleDriverTestClass singleDriverTestClass = this;
            synchronized (singleDriverTestClass) {
                rv = this.serverVersion;
                if (rv == null) {
                    try (Driver driver = this.getDriver();){
                        rv = this.serverVersion = ServerVersion.version((Driver)driver);
                    }
                }
            }
        }
        return rv;
    }

    public boolean databaseSupportJava8TimeTypes() {
        return this.getServerVersion().greaterThanOrEqual(ServerVersion.version((String)"Neo4j/3.4.0"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWithSessionFactoryOf(AbstractConfigurableDriver ogmDriver, Class[] inBasePackageClasses, Consumer<SessionFactory> consumerOfSessionFactory) {
        String[] basePackages = (String[])Arrays.stream(inBasePackageClasses).map(Class::getName).toArray(String[]::new);
        try (SessionFactory sessionFactory = null;){
            sessionFactory = new SessionFactory((org.neo4j.ogm.driver.Driver)ogmDriver, basePackages);
            consumerOfSessionFactory.accept(sessionFactory);
        }
    }

    @AfterClass
    public static void tearDownNeo4j() {
        serverControls.close();
    }
}

