/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.testutil;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Iterator;
import java.util.Scanner;

public final class TestUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getAvailablePort() {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot find available port: " + e.getMessage(), e);
        }
    }

    public static <T> T firstOrNull(Iterable<T> iterable) {
        return TestUtils.firstOrNull(iterable.iterator());
    }

    public static <T> T firstOrNull(Iterator<T> iterator) {
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    public static StringBuilder readCQLFile(String cqlFileName) {
        StringBuilder cypher = new StringBuilder();
        try (Scanner scanner = new Scanner(Thread.currentThread().getContextClassLoader().getResourceAsStream(cqlFileName));){
            scanner.useDelimiter(System.getProperty("line.separator"));
            while (scanner.hasNext()) {
                cypher.append(scanner.next()).append(' ');
            }
        }
        return cypher;
    }

    private TestUtils() {
    }
}

