/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.function.ThrowingSupplier;

public class CompletableFuture<T>
implements Future<T> {
    private static final State<?> UNRESOLVED = new State(){

        public Object get() {
            throw new IllegalStateException();
        }
    };
    private static final State<?> CANCELLED = new State(){

        public Object get() {
            throw new CancellationException();
        }
    };
    private final AtomicReference<State<T>> state = new AtomicReference(UNRESOLVED);
    private final CountDownLatch latch = new CountDownLatch(1);

    public boolean complete(final T value) {
        return this.state.get() == UNRESOLVED && this.resolve(new State<T>(){

            public T get() {
                return value;
            }
        });
    }

    public boolean completeExceptionally(final Throwable ex) {
        return this.state.get() == UNRESOLVED && this.resolve(new State<T>(){

            public T get() throws ExecutionException {
                throw new ExecutionException(ex);
            }
        });
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.state.get() == UNRESOLVED && this.resolve(CANCELLED);
    }

    private boolean resolve(State<T> newState) {
        if (!this.state.compareAndSet(UNRESOLVED, newState)) {
            return false;
        }
        this.latch.countDown();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.state.get() == CANCELLED;
    }

    @Override
    public boolean isDone() {
        return this.state.get() != UNRESOLVED;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.latch.await();
        return (T)this.state.get().get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.latch.await(timeout, unit)) {
            throw new TimeoutException();
        }
        return (T)this.state.get().get();
    }

    private static interface State<T>
    extends ThrowingSupplier<T, ExecutionException> {
    }
}

