/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import java.util.Arrays;

public class PrimitiveLongIntKeyValueArray {
    public static final int DEFAULT_INITIAL_CAPACITY = 100;
    public static final double DEFAULT_GROWTH_FACTOR = 0.2;
    private long[] naturalKeys = new long[100];
    private int[] naturalValues = new int[100];
    private long[] sortedKeys = new long[100];
    private int[] sortedValues = new int[100];
    private double growthFactor;
    private int size = 0;

    public PrimitiveLongIntKeyValueArray(int initialCapacity, double growthFactor) {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (growthFactor <= 0.0) {
            throw new IllegalArgumentException("Illegal growth factor: " + growthFactor);
        }
        this.naturalKeys = new long[100];
        this.naturalValues = new int[100];
        this.sortedKeys = new long[100];
        this.sortedValues = new int[100];
        this.growthFactor = growthFactor;
    }

    public PrimitiveLongIntKeyValueArray(int initialCapacity) {
        this(initialCapacity, 0.2);
    }

    public PrimitiveLongIntKeyValueArray() {
        this(100, 0.2);
    }

    public int capacity() {
        return this.naturalKeys.length;
    }

    public double growthFactor() {
        return this.growthFactor;
    }

    public void ensureCapacity(int newCapacity) {
        int capacity = this.naturalKeys.length;
        if (newCapacity > capacity) {
            long[] newNaturalKeys = new long[newCapacity];
            int[] newNaturalValues = new int[newCapacity];
            long[] newSortedKeys = new long[newCapacity];
            int[] newSortedValues = new int[newCapacity];
            for (int i = 0; i < capacity; ++i) {
                newNaturalKeys[i] = this.naturalKeys[i];
                newNaturalValues[i] = this.naturalValues[i];
                newSortedKeys[i] = this.sortedKeys[i];
                newSortedValues[i] = this.sortedValues[i];
            }
            this.naturalKeys = newNaturalKeys;
            this.naturalValues = newNaturalValues;
            this.sortedKeys = newSortedKeys;
            this.sortedValues = newSortedValues;
        }
    }

    public int size() {
        return this.size;
    }

    public int getOrDefault(long key, int defaultValue) {
        int index = Arrays.binarySearch(this.sortedKeys, 0, this.size, key);
        if (index >= 0) {
            return this.sortedValues[index];
        }
        return defaultValue;
    }

    public boolean putIfAbsent(long key, int value) {
        int index;
        int capacity = this.naturalKeys.length;
        if (this.size == capacity) {
            this.ensureCapacity((int)Math.floor(this.growthFactor * (double)capacity));
        }
        if ((index = Arrays.binarySearch(this.sortedKeys, 0, this.size, key)) >= 0) {
            return false;
        }
        index = -index - 1;
        for (int i = this.size; i > index; --i) {
            int j = i - 1;
            this.sortedKeys[i] = this.sortedKeys[j];
            this.sortedValues[i] = this.sortedValues[j];
        }
        this.naturalKeys[this.size] = key;
        this.naturalValues[this.size] = value;
        this.sortedKeys[index] = key;
        this.sortedValues[index] = value;
        ++this.size;
        return true;
    }

    public void reset(int newCapacity) {
        this.size = 0;
        this.ensureCapacity(newCapacity);
    }

    public long[] keys() {
        return Arrays.copyOfRange(this.naturalKeys, 0, this.size);
    }
}

