/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.concurrent;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class RecentK<Type>
implements Iterable<Type> {
    private final int maxItems;
    private final ConcurrentHashMap<Type, AtomicLong> recentItems = new ConcurrentHashMap();

    public RecentK(int maxItems) {
        this.maxItems = maxItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Type item) {
        AtomicLong counter = this.recentItems.get(item);
        if (counter != null) {
            counter.incrementAndGet();
        } else if (this.recentItems.size() >= this.maxItems) {
            ConcurrentHashMap<Type, AtomicLong> concurrentHashMap = this.recentItems;
            synchronized (concurrentHashMap) {
                while (this.recentItems.size() >= this.maxItems) {
                    this.removeItemWithLowestCount();
                }
                this.halveCounts();
                this.recentItems.putIfAbsent(item, new AtomicLong(1L));
            }
        } else {
            this.recentItems.putIfAbsent(item, new AtomicLong(1L));
        }
    }

    private void halveCounts() {
        for (AtomicLong count : this.recentItems.values()) {
            long next;
            long prev;
            while (!count.compareAndSet(prev = count.get(), next = Math.max(prev / 2L, 1L))) {
            }
        }
    }

    private void removeItemWithLowestCount() {
        Object lowestCountKey = null;
        long lowestCount = Long.MAX_VALUE;
        for (Map.Entry<Type, AtomicLong> entry : this.recentItems.entrySet()) {
            long currentCount = entry.getValue().get();
            if (currentCount >= lowestCount) continue;
            lowestCount = currentCount;
            lowestCountKey = entry.getKey();
        }
        if (lowestCountKey != null) {
            this.recentItems.remove(lowestCountKey);
        }
    }

    public Set<Type> recentItems() {
        return this.recentItems.keySet();
    }

    @Override
    public Iterator<Type> iterator() {
        return this.recentItems().iterator();
    }
}

