/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.concurrent;

import java.util.Arrays;
import org.neo4j.string.HexString;

public class DecayingFlags {
    private int[] flags;
    private final int keepalive;

    public DecayingFlags(int keepalive) {
        this.keepalive = keepalive;
        this.flags = new int[16];
    }

    public void flag(Key key) {
        int flag;
        if (key.index >= this.flags.length) {
            this.resize(key.index);
        }
        if ((flag = this.flags[key.index]) < this.keepalive) {
            this.flags[((Key)key).index] = flag + 1;
        }
    }

    public void sweep() {
        for (int i = 0; i < this.flags.length; ++i) {
            int count = this.flags[i];
            if (count <= 0) continue;
            this.flags[i] = count - 1;
        }
    }

    private synchronized void resize(int minSize) {
        int newSize;
        for (newSize = this.flags.length; newSize < minSize; newSize += 16) {
        }
        if (this.flags.length < newSize) {
            this.flags = Arrays.copyOf(this.flags, newSize);
        }
    }

    public String asHex() {
        byte[] bits = new byte[this.flags.length / 8];
        for (int i = 0; i < this.flags.length; i += 8) {
            bits[i / 8] = (byte)(this.bit(i) << 7 | this.bit(i + 1) << 6 | this.bit(i + 2) << 5 | this.bit(i + 3) << 4 | this.bit(i + 4) << 3 | this.bit(i + 5) << 2 | this.bit(i + 6) << 1 | this.bit(i + 7));
        }
        return HexString.encodeHexString((byte[])bits);
    }

    private int bit(int idx) {
        return this.flags[idx] > 0 ? 1 : 0;
    }

    public static class Key {
        private final int index;

        public Key(int index) {
            this.index = index;
        }

        public int index() {
            return this.index;
        }
    }
}

