/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class ASMAnnotationScanner {
    private final Set<String> scannedForDescriptors;

    ASMAnnotationScanner(Set<Class<?>> annotationsToScanFor) {
        this.scannedForDescriptors = annotationsToScanFor.stream().map(Class::descriptorString).collect(Collectors.toSet());
    }

    private boolean processClass(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ScannerClassVisitor classVisitor = new ScannerClassVisitor(this.scannedForDescriptors);
        try {
            reader.accept((ClassVisitor)classVisitor, 7);
        }
        catch (AnnotationFoundException ex) {
            return true;
        }
        return false;
    }

    public boolean checkIfClassContainsAnnotation(JarFile jar, JarEntry entry) {
        boolean bl;
        block9: {
            if (!entry.getName().endsWith(".class")) {
                return false;
            }
            InputStream stream = jar.getInputStream(entry);
            try {
                byte[] bytes = stream.readAllBytes();
                bl = this.processClass(bytes);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return false;
                }
            }
            stream.close();
        }
        return bl;
    }

    private static class ScannerClassVisitor
    extends ClassVisitor {
        private final Set<String> scannedForDescriptors;

        ScannerClassVisitor(Set<String> scannedForDescriptors) {
            super(589824);
            this.scannedForDescriptors = scannedForDescriptors;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new ScannerMethodVisitor(this.scannedForDescriptors);
        }
    }

    private static class AnnotationFoundException
    extends RuntimeException {
        AnnotationFoundException() {
            super("User plugin method found", null, false, false);
        }
    }

    private static class ScannerMethodVisitor
    extends MethodVisitor {
        private final Set<String> scannedForDescriptors;

        ScannerMethodVisitor(Set<String> scannedForDescriptors) {
            super(589824);
            this.scannedForDescriptors = scannedForDescriptors;
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (this.scannedForDescriptors.contains(descriptor)) {
                throw new AnnotationFoundException();
            }
            return null;
        }
    }
}

