/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.time.ZoneId;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.procedure.QueryLanguageScope;
import org.neo4j.kernel.api.procedure.SystemProcedure;
import org.neo4j.kernel.impl.api.TokenAccess;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.builtin.IndexProcedures;
import org.neo4j.procedure.builtin.NodePropertySchemaInfoResult;
import org.neo4j.procedure.builtin.ProceduresTimeFormatHelper;
import org.neo4j.procedure.builtin.RelationshipPropertySchemaInfoResult;
import org.neo4j.procedure.builtin.SchemaCalculator;
import org.neo4j.procedure.builtin.SchemaProcedure;
import org.neo4j.procedure.builtin.SpdBuiltInProcedures;
import org.neo4j.storageengine.api.StoreIdProvider;
import org.neo4j.storageengine.util.StoreIdDecodeUtils;

public class BuiltInProcedures {
    private static final int NOT_EXISTING_INDEX_ID = -1;
    static final long LONG_FIELD_NOT_CALCULATED = -1L;
    @Context
    public KernelTransaction kernelTransaction;
    @Context
    public Transaction transaction;
    @Context
    public DependencyResolver resolver;
    @Context
    public GraphDatabaseAPI graphDatabaseAPI;
    @Context
    public ProcedureCallContext callContext;
    @Context
    public SpdBuiltInProcedures spdBuiltInProcedures;

    @SystemProcedure
    @NotThreadSafe
    @Description(value="Provides information regarding the database.")
    @Procedure(name="db.info", mode=Mode.READ)
    public Stream<DatabaseInfo> databaseInfo() {
        StoreIdProvider storeIdProvider = (StoreIdProvider)this.graphDatabaseAPI.getDependencyResolver().resolveDependency(StoreIdProvider.class);
        String creationTime = ProceduresTimeFormatHelper.formatTime(storeIdProvider.getStoreId().getCreationTime(), this.getConfiguredTimeZone());
        return Stream.of(new DatabaseInfo(StoreIdDecodeUtils.decodeId((StoreIdProvider)storeIdProvider), this.graphDatabaseAPI.databaseName(), creationTime));
    }

    @SystemProcedure
    @NotThreadSafe
    @Description(value="List all labels attached to nodes within a database according to the user's access rights. The procedure returns empty results if the user is not authorized to view those labels.")
    @Procedure(name="db.labels", mode=Mode.READ)
    public Stream<LabelResult> listLabels() {
        List labelsInUse;
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        AccessMode mode = this.kernelTransaction.securityContext().mode();
        TokenRead tokenRead = this.kernelTransaction.tokenRead();
        try (KernelTransaction.Revertable ignore = this.kernelTransaction.overrideWith(SecurityContext.AUTH_DISABLED);){
            labelsInUse = Iterators.stream((Iterator)TokenAccess.LABELS.inUse(this.kernelTransaction.dataRead(), this.kernelTransaction.schemaRead(), this.kernelTransaction.tokenRead())).filter(label -> mode.allowsTraverseNode(new int[]{tokenRead.nodeLabel(label.name())})).map(LabelResult::new).collect(Collectors.toList());
        }
        return labelsInUse.stream();
    }

    @SystemProcedure
    @NotThreadSafe
    @Description(value="List all property keys in the database.")
    @Procedure(name="db.propertyKeys", mode=Mode.READ)
    public Stream<PropertyKeyResult> listPropertyKeys() {
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        List<PropertyKeyResult> propertyKeys = Iterators.stream((Iterator)TokenAccess.PROPERTY_KEYS.all(this.kernelTransaction.tokenRead())).map(PropertyKeyResult::new).toList();
        return propertyKeys.stream();
    }

    @SystemProcedure
    @NotThreadSafe
    @Description(value="List all types attached to relationships within a database according to the user's access rights. The procedure returns empty results if the user is not authorized to view those relationship types.")
    @Procedure(name="db.relationshipTypes", mode=Mode.READ)
    public Stream<RelationshipTypeResult> listRelationshipTypes() {
        List relTypesInUse;
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        AccessMode mode = this.kernelTransaction.securityContext().mode();
        TokenRead tokenRead = this.kernelTransaction.tokenRead();
        try (KernelTransaction.Revertable ignore = this.kernelTransaction.overrideWith(SecurityContext.AUTH_DISABLED);){
            relTypesInUse = Iterators.stream((Iterator)TokenAccess.RELATIONSHIP_TYPES.inUse(this.kernelTransaction.dataRead(), this.kernelTransaction.schemaRead(), this.kernelTransaction.tokenRead())).filter(type -> mode.allowsTraverseRelType(tokenRead.relationshipType(type.name()))).map(RelationshipTypeResult::new).collect(Collectors.toList());
        }
        return relTypesInUse.stream();
    }

    @SystemProcedure
    @NotThreadSafe
    @Description(value="Wait for an index to come online (for example: CALL db.awaitIndex(\"MyIndex\", 300)).")
    @Procedure(name="db.awaitIndex", mode=Mode.READ)
    public void awaitIndex(@Name(value="indexName", description="The name of the awaited index.") String indexName, @Name(value="timeOutSeconds", defaultValue="300", description="The maximum time to wait in seconds.") long timeout) throws ProcedureException {
        if (this.callContext.isSystemDatabase()) {
            return;
        }
        IndexProcedures indexProcedures = this.indexProcedures();
        indexProcedures.awaitIndexByName(indexName, timeout, TimeUnit.SECONDS);
    }

    @SystemProcedure
    @NotThreadSafe
    @Description(value="Wait for all indexes to come online (for example: CALL db.awaitIndexes(300)).")
    @Procedure(name="db.awaitIndexes", mode=Mode.READ)
    public void awaitIndexes(@Name(value="timeOutSeconds", defaultValue="300", description="The maximum time to wait in seconds.") long timeout) {
        if (this.callContext.isSystemDatabase()) {
            return;
        }
        this.transaction.schema().awaitIndexesOnline(timeout, TimeUnit.SECONDS);
    }

    @SystemProcedure
    @NotThreadSafe
    @Description(value="Schedule resampling of an index (for example: CALL db.resampleIndex(\"MyIndex\")).")
    @Procedure(name="db.resampleIndex", mode=Mode.READ)
    public void resampleIndex(@Name(value="indexName", description="The name of the index.") String indexName) throws ProcedureException {
        if (this.callContext.isSystemDatabase()) {
            return;
        }
        if (this.spdBuiltInProcedures.isGraphShard()) {
            this.spdBuiltInProcedures.resampleIndex(indexName);
        }
        IndexProcedures indexProcedures = this.indexProcedures();
        indexProcedures.resampleIndex(indexName);
    }

    @SystemProcedure
    @NotThreadSafe
    @Description(value="Schedule resampling of all outdated indexes.")
    @Procedure(name="db.resampleOutdatedIndexes", mode=Mode.READ)
    public void resampleOutdatedIndexes() {
        if (this.callContext.isSystemDatabase()) {
            return;
        }
        if (this.spdBuiltInProcedures.isGraphShard()) {
            this.spdBuiltInProcedures.resampleOutdatedIndexes();
        }
        IndexProcedures indexProcedures = this.indexProcedures();
        indexProcedures.resampleOutdatedIndexes();
    }

    @Admin
    @SystemProcedure
    @NotThreadSafe
    @Description(value="Triggers an index resample and waits for it to complete, and after that clears query caches. After this procedure has finished queries will be planned using the latest database statistics.")
    @Procedure(name="db.prepareForReplanning", mode=Mode.READ)
    public void prepareForReplanning(@Name(value="timeOutSeconds", defaultValue="300", description="The maximum time to wait in seconds.") long timeOutSeconds) throws ProcedureException {
        if (this.callContext.isSystemDatabase()) {
            return;
        }
        if (this.spdBuiltInProcedures.isGraphShard()) {
            this.spdBuiltInProcedures.prepareForReplanning();
        }
        IndexProcedures indexProcedures = this.indexProcedures();
        indexProcedures.resampleOutdatedIndexes(timeOutSeconds);
        ((QueryExecutionEngine)this.graphDatabaseAPI.getDependencyResolver().resolveDependency(QueryExecutionEngine.class)).clearQueryCaches();
    }

    @SystemProcedure
    @NotThreadSafe
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    @Procedure(name="db.schema.nodeTypeProperties", mode=Mode.READ, warning="The field `propertyTypes` will change output format in the next major version.")
    @Description(value="Show the derived property schema of the nodes in tabular form.")
    public Stream<NodePropertySchemaInfoResult> nodePropertySchemaCypher5() {
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        return new SchemaCalculator(this.kernelTransaction, false).calculateTabularResultStreamForNodes();
    }

    @SystemProcedure
    @NotThreadSafe
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Procedure(name="db.schema.nodeTypeProperties", mode=Mode.READ)
    @Description(value="Show the derived property schema of the nodes in tabular form.")
    public Stream<NodePropertySchemaInfoResult> nodePropertySchema() {
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        if (this.spdBuiltInProcedures.isGraphShard()) {
            return this.spdBuiltInProcedures.nodePropertySchema(this.kernelTransaction);
        }
        return new SchemaCalculator(this.kernelTransaction, true).calculateTabularResultStreamForNodes();
    }

    @SystemProcedure
    @NotThreadSafe
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    @Procedure(name="db.schema.relTypeProperties", mode=Mode.READ, warning="The field `propertyTypes` will change output format in the next major version.")
    @Description(value="Show the derived property schema of the relationships in tabular form.")
    public Stream<RelationshipPropertySchemaInfoResult> relationshipPropertySchemaCypher5() {
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        return new SchemaCalculator(this.kernelTransaction, false).calculateTabularResultStreamForRels();
    }

    @SystemProcedure
    @NotThreadSafe
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Procedure(name="db.schema.relTypeProperties", mode=Mode.READ)
    @Description(value="Show the derived property schema of the relationships in tabular form.")
    public Stream<RelationshipPropertySchemaInfoResult> relationshipPropertySchema() {
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        if (this.spdBuiltInProcedures.isGraphShard()) {
            return this.spdBuiltInProcedures.relationshipPropertySchema(this.kernelTransaction);
        }
        return new SchemaCalculator(this.kernelTransaction, true).calculateTabularResultStreamForRels();
    }

    @SystemProcedure
    @NotThreadSafe
    @Description(value="Visualizes the schema of the data based on available statistics. A new node is returned for each label. The properties represented on the node include: `name` (label name), `indexes` (list of indexes), and `constraints` (list of constraints). A relationship of a given type is returned for all possible combinations of start and end nodes. The properties represented on the relationship include: `name` (type name). Note that this may include additional relationships that do not exist in the data due to the information available in the count store. ")
    @Procedure(name="db.schema.visualization", mode=Mode.READ)
    public Stream<SchemaProcedure.GraphResult> schemaVisualization() {
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        return Stream.of(new SchemaProcedure((InternalTransaction)this.transaction).buildSchemaGraph());
    }

    @SystemProcedure(allowExpiredCredentials=true)
    @NotThreadSafe
    @Procedure(name="db.ping", mode=Mode.READ)
    @Description(value="This procedure can be used by client side tooling to test whether they are correctly connected to a database. The procedure is available in all databases and always returns true. A faulty connection can be detected by not being able to call this procedure.")
    public Stream<BooleanResult> ping() {
        return Stream.of(new BooleanResult(Boolean.TRUE));
    }

    private ZoneId getConfiguredTimeZone() {
        Config config = (Config)this.resolver.resolveDependency(Config.class);
        return ((LogTimeZone)config.get(GraphDatabaseSettings.db_timezone)).getZoneId();
    }

    private IndexProcedures indexProcedures() {
        return new IndexProcedures(this.kernelTransaction, (IndexingService)this.resolver.resolveDependency(IndexingService.class));
    }

    private IndexProviderDescriptor getIndexProviderDescriptor(String providerName) {
        return ((IndexingService)this.resolver.resolveDependency(IndexingService.class)).indexProviderByName(providerName);
    }

    public record DatabaseInfo(@Description(value="The id of the database.") String id, @Description(value="The name of the database.") String name, @Description(value="The creation date of the database, formatted according to the ISO-8601 Standard.") String creationDate) {
    }

    public record BooleanResult(@Description(value="Whether or not the connection call to the database has been successful.") Boolean success) {
    }

    public record RelationshipResult(Relationship relationship) {
    }

    public record WeightedRelationshipResult(Relationship relationship, double weight) {
    }

    public record WeightedNodeResult(Node node, double weight) {
    }

    public record NodeResult(Node node) {
    }

    public static class RelationshipTypeResult {
        @Description(value="A relationship type in the database.")
        public final String relationshipType;

        private RelationshipTypeResult(RelationshipType relationshipType) {
            this.relationshipType = relationshipType.name();
        }
    }

    public record PropertyKeyResult(@Description(value="A property key in the database.") String propertyKey) {
    }

    public static class LabelResult {
        @Description(value="A label within the database.")
        public final String label;

        private LabelResult(Label label) {
            this.label = label.name();
        }
    }
}

