/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.procedure.builtin.JmxQueryProcedure;
import org.neo4j.procedure.builtin.ListComponentsProcedure;

public class SpecialBuiltInProcedures
implements Supplier<List<CallableProcedure>> {
    private final List<CallableProcedure> builtins;

    private SpecialBuiltInProcedures(List<CallableProcedure> builtins) {
        this.builtins = builtins;
    }

    public static SpecialBuiltInProcedures from(String neo4jVersion, String neo4jEdition, Config config) {
        String customVersionConfig = (String)config.get(GraphDatabaseInternalSettings.custom_kernel_version);
        Boolean cypherExperimentalVersionsEnabled = (Boolean)config.get(GraphDatabaseInternalSettings.enable_experimental_cypher_versions);
        return new SpecialBuiltInProcedures(List.of(new ListComponentsProcedure(new QualifiedName("dbms", "components"), neo4jVersion, neo4jEdition, customVersionConfig, cypherExperimentalVersionsEnabled), new JmxQueryProcedure(new QualifiedName("dbms", "queryJmx"), ManagementFactory.getPlatformMBeanServer())));
    }

    @Override
    public List<CallableProcedure> get() {
        return this.builtins;
    }
}

