/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public final class TransactionId {
    private static final String SEPARATOR = "-transaction-";
    private static final String EXPECTED_FORMAT_MSG = "(expected format: <databasename>-transaction-<id>)";

    private TransactionId() {
    }

    public static String formatTransactionId(String database, long internalId) throws InvalidArgumentsException {
        if (internalId < 0L) {
            throw InvalidArgumentsException.internalError((String)TransactionId.class.getSimpleName(), (String)"Negative ids are not supported (expected format: <databasename>-transaction-<id>)");
        }
        NormalizedDatabaseName normalizedDatabaseName = new NormalizedDatabaseName(database);
        return normalizedDatabaseName.name() + SEPARATOR + internalId;
    }
}

