/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.collection.RawIterator;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregator;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.CallableUserAggregationFunction;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.procedure.impl.ProcedureHolder;
import org.neo4j.values.AnyValue;

public class ProcedureRegistry {
    private final ProcedureHolder<CallableProcedure> procedures = new ProcedureHolder();
    private final ProcedureHolder<CallableUserFunction> functions = new ProcedureHolder();
    private final ProcedureHolder<CallableUserAggregationFunction> aggregationFunctions = new ProcedureHolder();

    public void register(CallableProcedure proc, boolean overrideCurrentImplementation) throws ProcedureException {
        ProcedureSignature signature = proc.signature();
        QualifiedName name = signature.name();
        String descriptiveName = signature.toString();
        this.validateSignature(descriptiveName, signature.inputSignature(), "input");
        this.validateSignature(descriptiveName, signature.outputSignature(), "output");
        if (!signature.isVoid() && signature.outputSignature().isEmpty()) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Procedures with zero output fields must be declared as VOID", new Object[0]);
        }
        CallableProcedure oldImplementation = this.procedures.get(name);
        if (oldImplementation == null) {
            this.procedures.put(name, proc, signature.caseInsensitive());
        } else if (overrideCurrentImplementation) {
            this.procedures.put(name, proc, signature.caseInsensitive());
        } else {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to register procedure, because the name `%s` is already in use.", new Object[]{name});
        }
    }

    public void register(CallableUserFunction function, boolean overrideCurrentImplementation) throws ProcedureException {
        UserFunctionSignature signature = function.signature();
        QualifiedName name = signature.name();
        CallableUserFunction oldImplementation = this.functions.get(name);
        if (oldImplementation == null) {
            this.functions.put(name, function, signature.caseInsensitive());
        } else if (overrideCurrentImplementation) {
            this.functions.put(name, function, signature.caseInsensitive());
        } else {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to register function, because the name `%s` is already in use.", new Object[]{name});
        }
    }

    public void register(CallableUserAggregationFunction function, boolean overrideCurrentImplementation) throws ProcedureException {
        UserFunctionSignature signature = function.signature();
        QualifiedName name = signature.name();
        CallableUserFunction oldImplementation = this.functions.get(name);
        if (oldImplementation == null) {
            this.aggregationFunctions.put(name, function, signature.caseInsensitive());
        } else if (overrideCurrentImplementation) {
            this.aggregationFunctions.put(name, function, signature.caseInsensitive());
        } else {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to register aggregation function, because the name `%s` is already in use.", new Object[]{name});
        }
    }

    private void validateSignature(String descriptiveName, List<FieldSignature> fields, String fieldType) throws ProcedureException {
        HashSet<String> names = new HashSet<String>();
        for (FieldSignature field : fields) {
            if (names.add(field.name())) continue;
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Procedure `%s` cannot be registered, because it contains a duplicated " + fieldType + " field, '%s'. You need to rename or remove one of the duplicate fields.", new Object[]{descriptiveName, field.name()});
        }
    }

    public ProcedureHandle procedure(QualifiedName name) throws ProcedureException {
        CallableProcedure proc = this.procedures.get(name);
        if (proc == null) {
            throw this.noSuchProcedure(name);
        }
        return new ProcedureHandle(proc.signature(), this.procedures.idOf(name));
    }

    public UserFunctionHandle function(QualifiedName name) {
        CallableUserFunction func = this.functions.get(name);
        if (func == null) {
            return null;
        }
        return new UserFunctionHandle(func.signature(), this.functions.idOf(name), func.threadSafe());
    }

    public UserFunctionHandle aggregationFunction(QualifiedName name) {
        CallableUserAggregationFunction func = this.aggregationFunctions.get(name);
        if (func == null) {
            return null;
        }
        return new UserFunctionHandle(func.signature(), this.aggregationFunctions.idOf(name), false);
    }

    public RawIterator<AnyValue[], ProcedureException> callProcedure(Context ctx, int id, AnyValue[] input, ResourceTracker resourceTracker) throws ProcedureException {
        CallableProcedure proc;
        try {
            proc = this.procedures.get(id);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.noSuchProcedure(id);
        }
        return proc.apply(ctx, input, resourceTracker);
    }

    public AnyValue callFunction(Context ctx, int functionId, AnyValue[] input) throws ProcedureException {
        CallableUserFunction func;
        try {
            func = this.functions.get(functionId);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.noSuchFunction(functionId);
        }
        return func.apply(ctx, input);
    }

    public UserAggregator createAggregationFunction(Context ctx, int id) throws ProcedureException {
        try {
            CallableUserAggregationFunction func = this.aggregationFunctions.get(id);
            return func.create(ctx);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.noSuchFunction(id);
        }
    }

    private ProcedureException noSuchProcedure(QualifiedName name) {
        return new ProcedureException((Status)Status.Procedure.ProcedureNotFound, "There is no procedure with the name `%s` registered for this database instance. Please ensure you've spelled the procedure name correctly and that the procedure is properly deployed.", new Object[]{name});
    }

    private ProcedureException noSuchProcedure(int id) {
        return new ProcedureException((Status)Status.Procedure.ProcedureNotFound, "There is no procedure with the internal id `%d` registered for this database instance.", new Object[]{id});
    }

    private ProcedureException noSuchFunction(int id) {
        return new ProcedureException((Status)Status.Procedure.ProcedureNotFound, "There is no function with the internal id `%d` registered for this database instance.", new Object[]{id});
    }

    public Set<ProcedureSignature> getAllProcedures() {
        return this.procedures.all().stream().map(CallableProcedure::signature).collect(Collectors.toSet());
    }

    public Stream<UserFunctionSignature> getAllNonAggregatingFunctions() {
        return this.functions.all().stream().map(CallableUserFunction::signature);
    }

    public Stream<UserFunctionSignature> getAllAggregatingFunctions() {
        return this.aggregationFunctions.all().stream().map(CallableUserAggregationFunction::signature);
    }
}

