/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.exceptions.ComponentInjectionException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.CallableUserAggregationFunction;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.procedure.FailedLoadAggregatedFunction;
import org.neo4j.kernel.api.procedure.FailedLoadFunction;
import org.neo4j.kernel.api.procedure.FailedLoadProcedure;
import org.neo4j.kernel.api.procedure.SystemProcedure;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Internal;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;
import org.neo4j.procedure.UserFunction;
import org.neo4j.procedure.impl.ComponentRegistry;
import org.neo4j.procedure.impl.FieldInjections;
import org.neo4j.procedure.impl.FieldSetter;
import org.neo4j.procedure.impl.MethodSignatureCompiler;
import org.neo4j.procedure.impl.NamingRestrictions;
import org.neo4j.procedure.impl.ProcedureCompilation;
import org.neo4j.procedure.impl.ProcedureConfig;
import org.neo4j.procedure.impl.ProcedureOutputSignatureCompiler;
import org.neo4j.procedure.impl.TypeCheckers;

class ProcedureCompiler {
    private final ProcedureOutputSignatureCompiler outputSignatureCompiler;
    private final MethodSignatureCompiler inputSignatureDeterminer;
    private final FieldInjections safeFieldInjections;
    private final FieldInjections allFieldInjections;
    private final Log log;
    private final TypeCheckers typeCheckers;
    private final ProcedureConfig config;
    private final NamingRestrictions restrictions;

    ProcedureCompiler(TypeCheckers typeCheckers, ComponentRegistry safeComponents, ComponentRegistry allComponents, Log log, ProcedureConfig config) {
        this(new MethodSignatureCompiler(typeCheckers), new ProcedureOutputSignatureCompiler(typeCheckers), new FieldInjections(safeComponents), new FieldInjections(allComponents), log, typeCheckers, config, ProcedureCompiler::rejectEmptyNamespace);
    }

    private ProcedureCompiler(MethodSignatureCompiler inputSignatureCompiler, ProcedureOutputSignatureCompiler outputSignatureCompiler, FieldInjections safeFieldInjections, FieldInjections allFieldInjections, Log log, TypeCheckers typeCheckers, ProcedureConfig config, NamingRestrictions restrictions) {
        this.inputSignatureDeterminer = inputSignatureCompiler;
        this.outputSignatureCompiler = outputSignatureCompiler;
        this.safeFieldInjections = safeFieldInjections;
        this.allFieldInjections = allFieldInjections;
        this.log = log;
        this.typeCheckers = typeCheckers;
        this.config = config;
        this.restrictions = restrictions;
    }

    List<CallableUserFunction> compileFunction(Class<?> fcnDefinition, boolean isBuiltin) throws KernelException {
        try {
            List functionMethods = Arrays.stream(fcnDefinition.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(UserFunction.class)).collect(Collectors.toList());
            if (functionMethods.isEmpty()) {
                return Collections.emptyList();
            }
            this.assertValidConstructor(fcnDefinition);
            ArrayList<CallableUserFunction> out = new ArrayList<CallableUserFunction>(functionMethods.size());
            for (Method method : functionMethods) {
                String valueName = method.getAnnotation(UserFunction.class).value();
                String definedName = method.getAnnotation(UserFunction.class).name();
                QualifiedName funcName = this.extractName(fcnDefinition, method, valueName, definedName);
                if (isBuiltin || this.config.isWhitelisted(funcName.toString())) {
                    out.add(this.compileFunction(fcnDefinition, method, funcName));
                    continue;
                }
                this.log.warn(String.format("The function '%s' is not on the allowlist and won't be loaded.", funcName.toString()));
            }
            out.sort(Comparator.comparing(a -> a.signature().name().toString()));
            return out;
        }
        catch (KernelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, (Throwable)e, "Failed to compile function defined in `%s`: %s", new Object[]{fcnDefinition.getSimpleName(), e.getMessage()});
        }
    }

    List<CallableUserAggregationFunction> compileAggregationFunction(Class<?> fcnDefinition) throws KernelException {
        try {
            List methods = Arrays.stream(fcnDefinition.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(UserAggregationFunction.class)).collect(Collectors.toList());
            if (methods.isEmpty()) {
                return Collections.emptyList();
            }
            this.assertValidConstructor(fcnDefinition);
            ArrayList<CallableUserAggregationFunction> out = new ArrayList<CallableUserAggregationFunction>(methods.size());
            for (Method method : methods) {
                String definedName;
                String valueName;
                QualifiedName funcName = this.extractName(fcnDefinition, method, valueName = method.getAnnotation(UserAggregationFunction.class).value(), definedName = method.getAnnotation(UserAggregationFunction.class).name());
                if (this.config.isWhitelisted(funcName.toString())) {
                    out.add(this.compileAggregationFunction(fcnDefinition, method, funcName));
                    continue;
                }
                this.log.warn(String.format("The function '%s' is not on the allowlist and won't be loaded.", funcName.toString()));
            }
            out.sort(Comparator.comparing(a -> a.signature().name().toString()));
            return out;
        }
        catch (KernelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, (Throwable)e, "Failed to compile function defined in `%s`: %s", new Object[]{fcnDefinition.getSimpleName(), e.getMessage()});
        }
    }

    List<CallableProcedure> compileProcedure(Class<?> procDefinition, String warning, boolean fullAccess) throws KernelException {
        try {
            List procedureMethods = Arrays.stream(procDefinition.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(Procedure.class)).collect(Collectors.toList());
            if (procedureMethods.isEmpty()) {
                return Collections.emptyList();
            }
            this.assertValidConstructor(procDefinition);
            ArrayList<CallableProcedure> out = new ArrayList<CallableProcedure>(procedureMethods.size());
            for (Method method : procedureMethods) {
                String valueName = method.getAnnotation(Procedure.class).value();
                String definedName = method.getAnnotation(Procedure.class).name();
                QualifiedName procName = this.extractName(procDefinition, method, valueName, definedName);
                if (fullAccess || this.config.isWhitelisted(procName.toString())) {
                    out.add(this.compileProcedure(procDefinition, method, warning, fullAccess, procName));
                    continue;
                }
                this.log.warn(String.format("The procedure '%s' is not on the allowlist and won't be loaded.", procName.toString()));
            }
            out.sort(Comparator.comparing(a -> a.signature().name().toString()));
            return out;
        }
        catch (KernelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, (Throwable)e, "Failed to compile procedure defined in `%s`: %s", new Object[]{procDefinition.getSimpleName(), e.getMessage()});
        }
    }

    private CallableProcedure compileProcedure(Class<?> procDefinition, Method method, String warning, boolean fullAccess, QualifiedName procName) throws ProcedureException {
        List<FieldSignature> inputSignature = this.inputSignatureDeterminer.signatureFor(method);
        List<FieldSignature> outputSignature = this.outputSignatureCompiler.fieldSignatures(method);
        String description = this.description(method);
        Procedure procedure = method.getAnnotation(Procedure.class);
        Mode mode = procedure.mode();
        boolean admin = method.isAnnotationPresent(Admin.class);
        boolean systemProcedure = method.isAnnotationPresent(SystemProcedure.class);
        boolean internal = method.isAnnotationPresent(Internal.class);
        String deprecated = this.deprecated(method, () -> ((Procedure)procedure).deprecatedBy(), "Use of @Procedure(deprecatedBy) without @Deprecated in " + procName);
        List<FieldSetter> setters = this.allFieldInjections.setters(procDefinition);
        if (!fullAccess && !this.config.fullAccessFor(procName.toString())) {
            try {
                setters = this.safeFieldInjections.setters(procDefinition);
            }
            catch (ComponentInjectionException e) {
                description = this.describeAndLogLoadFailure(procName);
                ProcedureSignature signature = new ProcedureSignature(procName, inputSignature, outputSignature, Mode.DEFAULT, admin, null, new String[0], description, warning, procedure.eager(), false, systemProcedure, internal);
                return new FailedLoadProcedure(signature);
            }
        }
        ProcedureSignature signature = new ProcedureSignature(procName, inputSignature, outputSignature, mode, admin, deprecated, this.config.rolesFor(procName.toString()), description, warning, procedure.eager(), false, systemProcedure, internal);
        return ProcedureCompilation.compileProcedure(signature, setters, method);
    }

    private String describeAndLogLoadFailure(QualifiedName name) {
        String nameStr = name.toString();
        String description = nameStr + " is unavailable because it is sandboxed and has dependencies outside of the sandbox. Sandboxing is controlled by the " + GraphDatabaseSettings.procedure_unrestricted.name() + " setting. Only unrestrict procedures you can trust with access to database internals.";
        this.log.warn(description);
        return description;
    }

    private CallableUserFunction compileFunction(Class<?> procDefinition, Method method, QualifiedName procName) throws ProcedureException {
        this.restrictions.verify(procName);
        List<FieldSignature> inputSignature = this.inputSignatureDeterminer.signatureFor(method);
        Class<?> returnType = method.getReturnType();
        TypeCheckers.TypeChecker typeChecker = this.typeCheckers.checkerFor(returnType);
        String description = this.description(method);
        UserFunction function = method.getAnnotation(UserFunction.class);
        String deprecated = this.deprecated(method, () -> ((UserFunction)function).deprecatedBy(), "Use of @UserFunction(deprecatedBy) without @Deprecated in " + procName);
        List<FieldSetter> setters = this.allFieldInjections.setters(procDefinition);
        if (!this.config.fullAccessFor(procName.toString())) {
            try {
                setters = this.safeFieldInjections.setters(procDefinition);
            }
            catch (ComponentInjectionException e) {
                description = this.describeAndLogLoadFailure(procName);
                UserFunctionSignature signature = new UserFunctionSignature(procName, inputSignature, typeChecker.type(), deprecated, this.config.rolesFor(procName.toString()), description, null, false);
                return new FailedLoadFunction(signature);
            }
        }
        UserFunctionSignature signature = new UserFunctionSignature(procName, inputSignature, typeChecker.type(), deprecated, this.config.rolesFor(procName.toString()), description, null, false);
        return ProcedureCompilation.compileFunction(signature, setters, method);
    }

    private CallableUserAggregationFunction compileAggregationFunction(Class<?> definition, Method create, QualifiedName funcName) throws ProcedureException {
        this.restrictions.verify(funcName);
        Method update = null;
        Method result = null;
        Class<?> aggregator = create.getReturnType();
        for (Method m : aggregator.getDeclaredMethods()) {
            if (m.isAnnotationPresent(UserAggregationUpdate.class)) {
                if (update != null) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Class '%s' contains multiple methods annotated with '@%s'.", new Object[]{aggregator.getSimpleName(), UserAggregationUpdate.class.getSimpleName()});
                }
                update = m;
            }
            if (!m.isAnnotationPresent(UserAggregationResult.class)) continue;
            if (result != null) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Class '%s' contains multiple methods annotated with '@%s'.", new Object[]{aggregator.getSimpleName(), UserAggregationResult.class.getSimpleName()});
            }
            result = m;
        }
        if (result == null || update == null) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Class '%s' must contain methods annotated with both '@%s' as well as '@%s'.", new Object[]{aggregator.getSimpleName(), UserAggregationResult.class.getSimpleName(), UserAggregationUpdate.class.getSimpleName()});
        }
        if (update.getReturnType() != Void.TYPE) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Update method '%s' in %s has type '%s' but must have return type 'void'.", new Object[]{update.getName(), aggregator.getSimpleName(), update.getReturnType().getSimpleName()});
        }
        if (!Modifier.isPublic(create.getModifiers())) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Aggregation method '%s' in %s must be public.", new Object[]{create.getName(), definition.getSimpleName()});
        }
        if (!Modifier.isPublic(aggregator.getModifiers())) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Aggregation class '%s' must be public.", new Object[]{aggregator.getSimpleName()});
        }
        if (!Modifier.isPublic(update.getModifiers())) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Aggregation update method '%s' in %s must be public.", new Object[]{update.getName(), aggregator.getSimpleName()});
        }
        if (!Modifier.isPublic(result.getModifiers())) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Aggregation result method '%s' in %s must be public.", new Object[]{result.getName(), aggregator.getSimpleName()});
        }
        List<FieldSignature> inputSignature = this.inputSignatureDeterminer.signatureFor(update);
        Class<?> returnType = result.getReturnType();
        TypeCheckers.TypeChecker valueConverter = this.typeCheckers.checkerFor(returnType);
        String description = this.description(create);
        UserAggregationFunction function = create.getAnnotation(UserAggregationFunction.class);
        String deprecated = this.deprecated(create, () -> ((UserAggregationFunction)function).deprecatedBy(), "Use of @UserAggregationFunction(deprecatedBy) without @Deprecated in " + funcName);
        List<FieldSetter> setters = this.allFieldInjections.setters(definition);
        if (!this.config.fullAccessFor(funcName.toString())) {
            try {
                setters = this.safeFieldInjections.setters(definition);
            }
            catch (ComponentInjectionException e) {
                description = this.describeAndLogLoadFailure(funcName);
                UserFunctionSignature signature = new UserFunctionSignature(funcName, inputSignature, valueConverter.type(), deprecated, this.config.rolesFor(funcName.toString()), description, null, false);
                return new FailedLoadAggregatedFunction(signature);
            }
        }
        UserFunctionSignature signature = new UserFunctionSignature(funcName, inputSignature, valueConverter.type(), deprecated, this.config.rolesFor(funcName.toString()), description, null, false);
        return ProcedureCompilation.compileAggregation(signature, setters, create, update, result);
    }

    private String deprecated(Method method, Supplier<String> supplier, String warning) {
        String deprecatedBy = supplier.get();
        String deprecated = null;
        if (method.isAnnotationPresent(Deprecated.class)) {
            deprecated = deprecatedBy;
        } else if (!deprecatedBy.isEmpty()) {
            this.log.warn(warning);
            deprecated = deprecatedBy;
        }
        return deprecated;
    }

    private String description(Method method) {
        if (method.isAnnotationPresent(Description.class)) {
            return method.getAnnotation(Description.class).value();
        }
        return null;
    }

    private void assertValidConstructor(Class<?> procDefinition) throws ProcedureException {
        boolean hasValidConstructor = false;
        for (Constructor<?> constructor : procDefinition.getConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers()) || constructor.getParameterCount() != 0) continue;
            hasValidConstructor = true;
            break;
        }
        if (!hasValidConstructor) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to find a usable public no-argument constructor in the class `%s`. Please add a valid, public constructor, recompile the class and try again.", new Object[]{procDefinition.getSimpleName()});
        }
    }

    private QualifiedName extractName(Class<?> procDefinition, Method m, String valueName, String definedName) {
        String procName;
        String string = procName = definedName.isBlank() ? valueName : definedName;
        if (!procName.isBlank()) {
            String[] split = procName.split("\\.");
            if (split.length == 1) {
                return new QualifiedName(new String[0], split[0]);
            }
            int lastElement = split.length - 1;
            return new QualifiedName(Arrays.copyOf(split, lastElement), split[lastElement]);
        }
        Package pkg = procDefinition.getPackage();
        String[] namespace = pkg == null ? new String[]{} : pkg.getName().split("\\.");
        String name = m.getName();
        return new QualifiedName(namespace, name);
    }

    ProcedureCompiler withoutNamingRestrictions() {
        return new ProcedureCompiler(this.inputSignatureDeterminer, this.outputSignatureCompiler, this.safeFieldInjections, this.allFieldInjections, this.log, this.typeCheckers, this.config, name -> {});
    }

    private static void rejectEmptyNamespace(QualifiedName name) throws ProcedureException {
        if (name.namespace() == null || name.namespace().length == 0) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "It is not allowed to define functions in the root namespace please use a namespace, e.g. `@UserFunction(\"org.example.com.%s\")", new Object[]{name.name()});
        }
    }
}

