/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Function;
import org.neo4j.cypher.internal.evaluator.EvaluationException;
import org.neo4j.cypher.internal.evaluator.ExpressionEvaluator;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;

public class ListConverter
implements Function<String, DefaultParameterValue> {
    private final Neo4jTypes.AnyType neoType;
    private final ExpressionEvaluator evaluator;
    private final Type type;

    ListConverter(Type type, Neo4jTypes.AnyType neoType, ExpressionEvaluator evaluator) {
        this.type = type;
        this.neoType = neoType;
        this.evaluator = evaluator;
    }

    @Override
    public DefaultParameterValue apply(String s) {
        try {
            List list = (List)this.evaluator.evaluate(s, List.class);
            this.typeCheck(list, this.type);
            return DefaultParameterValue.ntList((List)list, (Neo4jTypes.AnyType)this.neoType);
        }
        catch (EvaluationException e) {
            throw new IllegalArgumentException(String.format("%s is not a valid list expression", s), e);
        }
    }

    private void typeCheck(List<?> list, Type innerType) {
        if (list == null) {
            return;
        }
        for (Object obj : list) {
            if (obj == null) continue;
            if (innerType instanceof Class) {
                Class clazz = (Class)innerType;
                if (clazz.isAssignableFrom(obj.getClass())) continue;
                throw new IllegalArgumentException(String.format("Expects a list of %s but got a list of %s", clazz.getSimpleName(), obj.getClass().getSimpleName()));
            }
            if (!List.class.isAssignableFrom(obj.getClass()) || !(innerType instanceof ParameterizedType)) continue;
            this.typeCheck((List)obj, ((ParameterizedType)innerType).getActualTypeArguments()[0]);
        }
    }
}

