/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.impl.core.TransactionalEntityFactory;
import org.neo4j.kernel.impl.util.BaseToObjectValueWriter;
import org.neo4j.procedure.builtin.ProceduresTimeFormatHelper;
import org.neo4j.procedure.builtin.QueryId;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.virtual.MapValue;

public class QueryStatusResult {
    public final String queryId;
    public final String username;
    public final Map<String, Object> metaData;
    public final String query;
    public final Map<String, Object> parameters;
    public final String planner;
    public final String runtime;
    public final List<Map<String, String>> indexes;
    public final String startTime;
    public final String protocol;
    public final String clientAddress;
    public final String requestUri;
    public final String status;
    public final Map<String, Object> resourceInformation;
    public final long activeLockCount;
    public final long elapsedTimeMillis;
    public final Long cpuTimeMillis;
    public final long waitTimeMillis;
    public final Long idleTimeMillis;
    public final Long allocatedBytes;
    public final long pageHits;
    public final long pageFaults;
    public final String connectionId;
    public final String database;

    QueryStatusResult(ExecutingQuery query, TransactionalEntityFactory manager, ZoneId zoneId, String database) throws InvalidArgumentsException {
        this(query.snapshot(), manager, zoneId, database);
    }

    private QueryStatusResult(QuerySnapshot query, TransactionalEntityFactory manager, ZoneId zoneId, String database) throws InvalidArgumentsException {
        this.queryId = new QueryId(query.internalQueryId()).toString();
        this.username = query.username();
        this.query = query.obfuscatedQueryText().orElse(null);
        this.database = database;
        this.parameters = QueryStatusResult.asRawMap(query.obfuscatedQueryParameters().orElse(MapValue.EMPTY), new ParameterWriter(manager));
        this.startTime = ProceduresTimeFormatHelper.formatTime(query.startTimestampMillis(), zoneId);
        this.elapsedTimeMillis = QueryStatusResult.asMillis(query.elapsedTimeMicros());
        ClientConnectionInfo clientConnection = query.clientConnection();
        this.protocol = clientConnection.protocol();
        this.clientAddress = clientConnection.clientAddress();
        this.requestUri = clientConnection.requestURI();
        this.metaData = query.transactionAnnotationData();
        OptionalLong cpuTime = query.cpuTimeMicros();
        this.cpuTimeMillis = cpuTime.isPresent() ? Long.valueOf(cpuTime.getAsLong()) : null;
        this.status = query.status();
        this.resourceInformation = query.resourceInformation();
        this.activeLockCount = query.activeLockCount();
        this.waitTimeMillis = QueryStatusResult.asMillis(query.waitTimeMicros());
        OptionalLong idleTimeMicros = query.idleTimeMicros();
        this.idleTimeMillis = idleTimeMicros.isPresent() ? QueryStatusResult.asMillis(idleTimeMicros.getAsLong()) : null;
        this.planner = query.planner();
        this.runtime = query.runtime();
        this.indexes = query.indexes();
        long bytes = query.allocatedBytes();
        this.allocatedBytes = bytes == -1L ? null : Long.valueOf(bytes);
        this.pageHits = query.pageHits();
        this.pageFaults = query.pageFaults();
        this.connectionId = clientConnection.connectionId();
    }

    private static Long asMillis(Long micros) {
        return micros == null ? null : Long.valueOf(TimeUnit.MICROSECONDS.toMillis(micros));
    }

    private static Map<String, Object> asRawMap(MapValue mapValue, ParameterWriter writer) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        mapValue.foreach((s, value) -> {
            value.writeTo((AnyValueWriter)writer);
            map.put((String)s, writer.value());
        });
        return map;
    }

    private static class ParameterWriter
    extends BaseToObjectValueWriter<RuntimeException> {
        private final TransactionalEntityFactory entityFactory;

        private ParameterWriter(TransactionalEntityFactory entityFactory) {
            this.entityFactory = entityFactory;
        }

        protected Node newNodeEntityById(long id) {
            return this.entityFactory.newNodeEntity(id);
        }

        protected Relationship newRelationshipEntityById(long id) {
            return this.entityFactory.newRelationshipEntity(id);
        }

        protected Point newPoint(final CoordinateReferenceSystem crs, final double[] coordinate) {
            return new Point(){

                public String getGeometryType() {
                    return "Point";
                }

                public List<Coordinate> getCoordinates() {
                    return Collections.singletonList(new Coordinate(coordinate));
                }

                public CRS getCRS() {
                    return crs;
                }
            };
        }
    }
}

