/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.routing;

import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.logging.LogProvider;
import org.neo4j.procedure.builtin.routing.AbstractRoutingProcedureInstaller;
import org.neo4j.procedure.builtin.routing.ClientRoutingDomainChecker;
import org.neo4j.procedure.builtin.routing.GetRoutingTableProcedure;
import org.neo4j.procedure.builtin.routing.LocalRoutingTableProcedureValidator;
import org.neo4j.procedure.builtin.routing.RoutingOption;
import org.neo4j.procedure.builtin.routing.RoutingTableTTLProvider;
import org.neo4j.procedure.builtin.routing.SingleAddressRoutingTableProvider;

public final class SingleInstanceRoutingProcedureInstaller
extends AbstractRoutingProcedureInstaller {
    private static final String DESCRIPTION = "Returns endpoints of this instance.";
    private final DatabaseManager<?> databaseManager;
    private final ClientRoutingDomainChecker clientRoutingDomainChecker;
    private final ConnectorPortRegister portRegister;
    private final Config config;
    private final LogProvider logProvider;
    private final DefaultDatabaseResolver defaultDatabaseResolver;

    public SingleInstanceRoutingProcedureInstaller(DatabaseManager<?> databaseManager, ClientRoutingDomainChecker clientRoutingDomainChecker, ConnectorPortRegister portRegister, Config config, LogProvider logProvider, DefaultDatabaseResolver defaultDatabaseResolver) {
        this.databaseManager = databaseManager;
        this.clientRoutingDomainChecker = clientRoutingDomainChecker;
        this.portRegister = portRegister;
        this.config = config;
        this.logProvider = logProvider;
        this.defaultDatabaseResolver = defaultDatabaseResolver;
    }

    @Override
    public GetRoutingTableProcedure createProcedure(List<String> namespace) {
        LocalRoutingTableProcedureValidator validator = new LocalRoutingTableProcedureValidator(this.databaseManager);
        SingleAddressRoutingTableProvider routingTableProvider = new SingleAddressRoutingTableProvider(this.portRegister, RoutingOption.ROUTE_WRITE_AND_READ, this.config, this.logProvider, RoutingTableTTLProvider.ttlFromConfig(this.config));
        return new GetRoutingTableProcedure(namespace, DESCRIPTION, this.databaseManager, validator, routingTableProvider, this.clientRoutingDomainChecker, this.config, this.logProvider, this.defaultDatabaseResolver);
    }
}

