/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.routing;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.procedure.builtin.routing.ClientSideRoutingTableProvider;
import org.neo4j.procedure.builtin.routing.RoutingOption;
import org.neo4j.procedure.builtin.routing.RoutingResult;
import org.neo4j.procedure.builtin.routing.RoutingTableProcedureHelpers;
import org.neo4j.procedure.builtin.routing.RoutingTableTTLProvider;
import org.neo4j.procedure.builtin.routing.ServerSideRoutingTableProvider;
import org.neo4j.values.virtual.MapValue;

public class SingleAddressRoutingTableProvider
implements ClientSideRoutingTableProvider,
ServerSideRoutingTableProvider {
    private final ConnectorPortRegister portRegister;
    private final RoutingOption routingOption;
    private final RoutingTableTTLProvider routingTableTTLProvider;
    private final Config config;
    private final Log log;

    public SingleAddressRoutingTableProvider(ConnectorPortRegister portRegister, RoutingOption routingOption, Config config, LogProvider logProvider, RoutingTableTTLProvider ttlProvider) {
        this.portRegister = portRegister;
        this.routingOption = routingOption;
        this.routingTableTTLProvider = ttlProvider;
        this.config = config;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public RoutingResult getRoutingResultForClientSideRouting(NamedDatabaseId databaseId, MapValue routingContext) throws ProcedureException {
        return SingleAddressRoutingTableProvider.createSingleAddressRoutingResult(this.findBoltAddressToUse(routingContext), this.routingTableTTLProvider.nextTTL().toMillis(), this.routingOption);
    }

    private static RoutingResult createSingleAddressRoutingResult(SocketAddress address, long routingTableTtl, RoutingOption option) {
        List<SocketAddress> addresses = List.of(address);
        List<Object> routeEndpoints = option.route ? addresses : Collections.emptyList();
        List<Object> writeEndpoints = option.write ? addresses : Collections.emptyList();
        List<Object> readEndpoints = option.read ? addresses : Collections.emptyList();
        return new RoutingResult(routeEndpoints, writeEndpoints, readEndpoints, routingTableTtl);
    }

    private SocketAddress findBoltAddressToUse(MapValue routingContext) throws ProcedureException {
        Optional<SocketAddress> addressToUse = RoutingTableProcedureHelpers.findClientProvidedAddress(routingContext, 7687, this.log);
        return this.ensureBoltAddressIsUsable(addressToUse);
    }

    private SocketAddress ensureBoltAddressIsUsable(Optional<SocketAddress> address) {
        HostnamePort localAddress;
        SocketAddress addressToUse = address.filter(c -> c.getPort() > 0).orElse((SocketAddress)this.config.get(BoltConnector.advertised_address));
        if (addressToUse.getPort() <= 0 && (localAddress = this.portRegister.getLocalAddress("bolt")) != null) {
            addressToUse = new SocketAddress(addressToUse.getHostname(), localAddress.getPort());
        }
        return addressToUse;
    }

    @Override
    public RoutingResult getServerSideRoutingTable(Optional<SocketAddress> clientProvidedAddress) {
        SocketAddress address = this.ensureBoltAddressIsUsable(clientProvidedAddress);
        return SingleAddressRoutingTableProvider.createSingleAddressRoutingResult(address, this.routingTableTTLProvider.nextTTL().toMillis(), this.routingOption);
    }
}

