/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.routing;

import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.logging.LogProvider;
import org.neo4j.procedure.builtin.routing.AbstractRoutingProcedureInstaller;
import org.neo4j.procedure.builtin.routing.ClientRoutingDomainChecker;
import org.neo4j.procedure.builtin.routing.DatabaseAvailabilityChecker;
import org.neo4j.procedure.builtin.routing.GetRoutingTableProcedure;
import org.neo4j.procedure.builtin.routing.LocalRoutingTableProcedureValidator;
import org.neo4j.procedure.builtin.routing.RoutingOption;
import org.neo4j.procedure.builtin.routing.RoutingTableTTLProvider;
import org.neo4j.procedure.builtin.routing.SingleAddressRoutingTableProvider;

public final class SingleInstanceRoutingProcedureInstaller
extends AbstractRoutingProcedureInstaller {
    private static final String DESCRIPTION = "Returns endpoints of this instance.";
    private final DatabaseAvailabilityChecker databaseAvailabilityChecker;
    private final DatabaseReferenceRepository databaseReferenceRepo;
    private final ClientRoutingDomainChecker clientRoutingDomainChecker;
    private final ConnectorPortRegister portRegister;
    private final Config config;
    private final LogProvider logProvider;

    public SingleInstanceRoutingProcedureInstaller(DatabaseAvailabilityChecker databaseAvailabilityChecker, ClientRoutingDomainChecker clientRoutingDomainChecker, ConnectorPortRegister portRegister, Config config, LogProvider logProvider, DatabaseReferenceRepository databaseReferenceRepo) {
        this.databaseAvailabilityChecker = databaseAvailabilityChecker;
        this.clientRoutingDomainChecker = clientRoutingDomainChecker;
        this.portRegister = portRegister;
        this.config = config;
        this.logProvider = logProvider;
        this.databaseReferenceRepo = databaseReferenceRepo;
    }

    @Override
    public GetRoutingTableProcedure createProcedure(List<String> namespace) {
        LocalRoutingTableProcedureValidator validator = new LocalRoutingTableProcedureValidator(this.databaseAvailabilityChecker, this.databaseReferenceRepo);
        SingleAddressRoutingTableProvider routingTableProvider = new SingleAddressRoutingTableProvider(this.portRegister, RoutingOption.ROUTE_WRITE_AND_READ, this.config, this.logProvider, RoutingTableTTLProvider.ttlFromConfig(this.config));
        return new GetRoutingTableProcedure(namespace, DESCRIPTION, this.databaseReferenceRepo, validator, routingTableProvider, this.clientRoutingDomainChecker, this.config, this.logProvider);
    }
}

