/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.routing;

import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.procedure.builtin.routing.RoutingTableProcedureValidator;

public abstract class BaseRoutingTableProcedureValidator
implements RoutingTableProcedureValidator {
    protected final DatabaseReferenceRepository databaseReferenceRepository;

    protected BaseRoutingTableProcedureValidator(DatabaseReferenceRepository databaseReferenceRepository) {
        this.databaseReferenceRepository = databaseReferenceRepository;
    }

    @Override
    public void assertDatabaseExists(DatabaseReference databaseReference) throws ProcedureException {
        this.databaseReferenceRepository.getByAlias(databaseReference.alias()).orElseThrow(() -> BaseRoutingTableProcedureValidator.databaseNotFoundException(databaseReference.alias().name()));
    }

    protected static ProcedureException databaseNotAvailableException(String databaseName) {
        return new ProcedureException((Status)Status.General.DatabaseUnavailable, "Unable to get a routing table for database '" + databaseName + "' because this database is unavailable", new Object[0]);
    }

    protected static ProcedureException databaseNotFoundException(String databaseName) {
        return new ProcedureException((Status)Status.Database.DatabaseNotFound, "Unable to get a routing table for database '" + databaseName + "' because this database does not exist", new Object[0]);
    }
}

