/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.CallableUserAggregationFunction;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.procedure.ProcedureView;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.NullLog;
import org.neo4j.procedure.builtin.SpecialBuiltInProcedures;
import org.neo4j.procedure.impl.ComponentRegistry;
import org.neo4j.procedure.impl.ProcedureCompiler;
import org.neo4j.procedure.impl.ProcedureConfig;
import org.neo4j.procedure.impl.ProcedureJarLoader;
import org.neo4j.procedure.impl.ProcedureRegistry;
import org.neo4j.procedure.impl.ProcedureViewImpl;
import org.neo4j.procedure.impl.TypeCheckers;
import org.neo4j.util.VisibleForTesting;

public class GlobalProceduresRegistry
extends LifecycleAdapter
implements GlobalProcedures {
    private final ProcedureRegistry registry = new ProcedureRegistry();
    private final TypeCheckers typeCheckers;
    private final ComponentRegistry safeComponents = new ComponentRegistry();
    private final ComponentRegistry allComponents = new ComponentRegistry();
    private final ProcedureCompiler compiler;
    private final Supplier<List<CallableProcedure>> builtin;
    private final Path proceduresDirectory;
    private final InternalLog log;
    private final RegistrationUpdater updater = new RegistrationUpdater();
    private static final AtomicLong SIGNATURE_VERSION_GENERATOR = new AtomicLong(0L);
    private final AtomicReference<ProcedureView> currentProcedureView = new AtomicReference<ProcedureView>(GlobalProceduresRegistry.makeSnapshot(this.registry, this.safeComponents, this.allComponents));

    @VisibleForTesting
    public GlobalProceduresRegistry() {
        this(SpecialBuiltInProcedures.from("N/A", "N/A"), null, (InternalLog)NullLog.getInstance(), ProcedureConfig.DEFAULT);
    }

    public GlobalProceduresRegistry(Supplier<List<CallableProcedure>> builtin, Path proceduresDirectory, InternalLog log, ProcedureConfig config) {
        this.builtin = builtin;
        this.proceduresDirectory = proceduresDirectory;
        this.log = log;
        this.typeCheckers = new TypeCheckers();
        this.compiler = new ProcedureCompiler(this.typeCheckers, this.safeComponents, this.allComponents, log, config);
    }

    public void register(CallableProcedure proc) throws ProcedureException {
        try (Resource ignored = this.updater.acquire();){
            this.registry.register(proc);
        }
    }

    public void register(CallableUserFunction function) throws ProcedureException {
        try (Resource ignored = this.updater.acquire();){
            this.registry.register(function);
        }
    }

    public void register(CallableUserAggregationFunction function) throws ProcedureException {
        try (Resource ignored = this.updater.acquire();){
            this.registry.register(function);
        }
    }

    public void registerProcedure(Class<?> proc) throws ProcedureException {
        try (Resource ignored = this.updater.acquire();){
            for (CallableProcedure procedure : this.compiler.compileProcedure(proc, true)) {
                this.registry.register(procedure);
            }
        }
    }

    public void registerFunction(Class<?> func) throws ProcedureException {
        try (Resource ignored = this.updater.acquire();){
            for (CallableUserFunction function : this.compiler.compileFunction(func, false)) {
                this.registry.register(function);
            }
        }
    }

    public void registerAggregationFunction(Class<?> func) throws ProcedureException {
        try (Resource ignored = this.updater.acquire();){
            for (CallableUserAggregationFunction aggregation : this.compiler.compileAggregationFunction(func)) {
                this.registry.register(aggregation);
            }
        }
    }

    public void registerType(Class<?> javaClass, Neo4jTypes.AnyType type) {
        this.typeCheckers.registerType(javaClass, new TypeCheckers.DefaultValueConverter(type));
    }

    public <T> void registerComponent(Class<T> cls, ThrowingFunction<Context, T, ProcedureException> provider, boolean safe) {
        try (Resource ignored = this.updater.acquire();){
            if (safe) {
                this.safeComponents.register(cls, provider);
            }
            this.allComponents.register(cls, provider);
        }
    }

    public ProcedureView getCurrentView() {
        return this.currentProcedureView.getAcquire();
    }

    public void start() throws Exception {
        try (Resource ignored = this.updater.acquire();){
            ProcedureJarLoader loader = new ProcedureJarLoader(this.compiler, this.log);
            ProcedureJarLoader.Callables callables = loader.loadProceduresFromDir(this.proceduresDirectory);
            for (CallableProcedure callableProcedure : callables.procedures()) {
                this.registry.register(callableProcedure);
            }
            for (CallableUserFunction callableUserFunction : callables.functions()) {
                this.registry.register(callableUserFunction);
            }
            for (CallableUserAggregationFunction callableUserAggregationFunction : callables.aggregationFunctions()) {
                this.registry.register(callableUserAggregationFunction);
            }
            for (CallableProcedure callableProcedure : this.builtin.get()) {
                this.registry.register(callableProcedure);
            }
        }
    }

    @VisibleForTesting
    public void unregister(QualifiedName name) {
        try (Resource ignored = this.updater.acquire();){
            this.registry.unregister(name);
        }
    }

    public BulkRegistration bulk() {
        return new BulkRegistration(this.updater.acquire());
    }

    private static ProcedureView makeSnapshot(ProcedureRegistry registry, ComponentRegistry safeComponents, ComponentRegistry allComponents) {
        return ProcedureViewImpl.snapshot(SIGNATURE_VERSION_GENERATOR.incrementAndGet(), registry, safeComponents, allComponents);
    }

    private class RegistrationUpdater {
        private final ReentrantLock lock = new ReentrantLock();

        private RegistrationUpdater() {
        }

        Resource acquire() {
            this.lock.lock();
            return () -> {
                try {
                    GlobalProceduresRegistry.this.currentProcedureView.setRelease(GlobalProceduresRegistry.makeSnapshot(GlobalProceduresRegistry.this.registry, GlobalProceduresRegistry.this.safeComponents, GlobalProceduresRegistry.this.allComponents));
                }
                finally {
                    this.lock.unlock();
                }
            };
        }
    }

    public class BulkRegistration
    implements GlobalProcedures,
    Resource {
        final Resource onClose;

        private BulkRegistration(Resource onClose) {
            this.onClose = onClose;
        }

        public void register(CallableProcedure proc) throws ProcedureException {
            GlobalProceduresRegistry.this.registry.register(proc);
        }

        public void register(CallableUserFunction function) throws ProcedureException {
            GlobalProceduresRegistry.this.registry.register(function);
        }

        public void register(CallableUserAggregationFunction function) throws ProcedureException {
            GlobalProceduresRegistry.this.registry.register(function);
        }

        public void registerProcedure(Class<?> proc) throws ProcedureException {
            for (CallableProcedure procedure : GlobalProceduresRegistry.this.compiler.compileProcedure(proc, true)) {
                GlobalProceduresRegistry.this.registry.register(procedure);
            }
        }

        public void registerFunction(Class<?> func) throws ProcedureException {
            for (CallableUserFunction function : GlobalProceduresRegistry.this.compiler.compileFunction(func, false)) {
                GlobalProceduresRegistry.this.registry.register(function);
            }
        }

        public void registerAggregationFunction(Class<?> func) throws ProcedureException {
            for (CallableUserAggregationFunction aggregation : GlobalProceduresRegistry.this.compiler.compileAggregationFunction(func)) {
                GlobalProceduresRegistry.this.registry.register(aggregation);
            }
        }

        public void registerType(Class<?> javaClass, Neo4jTypes.AnyType type) {
            GlobalProceduresRegistry.this.typeCheckers.registerType(javaClass, new TypeCheckers.DefaultValueConverter(type));
        }

        public <T> void registerComponent(Class<T> cls, ThrowingFunction<Context, T, ProcedureException> provider, boolean safe) {
            if (safe) {
                GlobalProceduresRegistry.this.safeComponents.register(cls, provider);
            }
            GlobalProceduresRegistry.this.allComponents.register(cls, provider);
        }

        @VisibleForTesting
        public void unregister(QualifiedName name) {
            GlobalProceduresRegistry.this.registry.unregister(name);
        }

        public ProcedureView getCurrentView() {
            return GlobalProceduresRegistry.this.currentProcedureView.getAcquire();
        }

        public void close() {
            this.onClose.close();
        }
    }
}

