/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.graphschema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.builtin.graphschema.Introspect;
import org.neo4j.procedure.builtin.graphschema.SchemaNames;

public final class GraphSchema {
    private final Map<String, Token> nodeLabels;
    private final Map<String, Token> relationshipTypes;
    private final Map<Ref, NodeObjectType> nodeObjectTypes;
    private final Map<Ref, RelationshipObjectType> relationshipObjectTypes;

    public static GraphSchema build(Transaction transaction, Introspect.Config config) throws Exception {
        return new Introspector(transaction, config).introspect();
    }

    private GraphSchema(Map<String, Token> nodeLabels, Map<String, Token> relationshipTypes, Map<Ref, NodeObjectType> nodeObjectTypes, Map<Ref, RelationshipObjectType> relationshipObjectTypes) {
        this.nodeLabels = nodeLabels;
        this.relationshipTypes = relationshipTypes;
        this.nodeObjectTypes = nodeObjectTypes;
        this.relationshipObjectTypes = relationshipObjectTypes;
    }

    public Map<String, Token> nodeLabels() {
        return this.nodeLabels;
    }

    public Map<String, Token> relationshipTypes() {
        return this.relationshipTypes;
    }

    public Map<Ref, NodeObjectType> nodeObjectTypes() {
        return this.nodeObjectTypes;
    }

    public Map<Ref, RelationshipObjectType> relationshipObjectTypes() {
        return this.relationshipObjectTypes;
    }

    static class Introspector {
        static final Long DEFAULT_SAMPLE_SIZE = 100L;
        private static final Supplier<String> ID_GENERATOR = () -> UUID.randomUUID().toString();
        private static final Pattern ENCLOSING_TICK_MARKS = Pattern.compile("^`(.+)`$");
        private static final Map<String, String> TYPE_MAPPING = Map.of("Long", "integer", "Double", "float");
        private final Transaction transaction;
        private final Introspect.Config config;

        private Introspector(Transaction transaction, Introspect.Config config) {
            this.transaction = transaction;
            this.config = config;
        }

        GraphSchema introspect() throws Exception {
            Map<String, Token> nodeLabels = this.getNodeLabels();
            Map<String, Token> relationshipTypes = this.getRelationshipTypes();
            CachingUnaryOperator<String> nodeObjectTypeIdGenerator = new CachingUnaryOperator<String>(new NodeObjectIdGenerator(this.config.useConstantIds()));
            RelationshipObjectIdGenerator relationshipObjectIdGenerator = new RelationshipObjectIdGenerator(this.config.useConstantIds());
            Map<Ref, NodeObjectType> nodeObjectTypes = this.getNodeObjectTypes(nodeObjectTypeIdGenerator, nodeLabels);
            Map<Ref, RelationshipObjectType> relationshipObjectTypes = this.getRelationshipObjectTypes(nodeObjectTypeIdGenerator, relationshipObjectIdGenerator, relationshipTypes);
            return new GraphSchema(nodeLabels, relationshipTypes, nodeObjectTypes, relationshipObjectTypes);
        }

        private Map<String, Token> getNodeLabels() throws Exception {
            return this.getToken(this.transaction.getAllLabelsInUse(), Label::name, this.config.quoteTokens(), this.config.useConstantIds() ? arg_0 -> Introspector.lambda$getNodeLabels$1("nl:%s", arg_0) : ignored -> ID_GENERATOR.get());
        }

        private Map<String, Token> getRelationshipTypes() throws Exception {
            return this.getToken(this.transaction.getAllRelationshipTypesInUse(), RelationshipType::name, this.config.quoteTokens(), this.config.useConstantIds() ? arg_0 -> Introspector.lambda$getRelationshipTypes$3("rt:%s", arg_0) : ignored -> ID_GENERATOR.get());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> Map<String, Token> getToken(Iterable<T> tokensInUse, Function<T, String> nameExtractor, boolean quoteTokens, UnaryOperator<String> idGenerator) throws Exception {
            Function<Object, Object> valueMapper = Function.identity();
            if (quoteTokens) {
                valueMapper = token -> new Token(token.id(), SchemaNames.sanitize(token.value()).orElse(token.value()));
            }
            try {
                Map<String, Token> map = StreamSupport.stream(tokensInUse.spliterator(), false).map(label -> {
                    String tokenValue = (String)nameExtractor.apply(label);
                    return new Token((String)idGenerator.apply(tokenValue), tokenValue);
                }).collect(Collectors.toMap(Token::value, valueMapper));
                return map;
            }
            finally {
                if (tokensInUse instanceof Resource) {
                    Resource resource = (Resource)tokensInUse;
                    resource.close();
                }
            }
        }

        private static String getRelationshipPropertiesQuery(Introspect.Config config) {
            String template = "CALL db.schema.relTypeProperties() YIELD relType, propertyName, propertyTypes, mandatory\nWITH substring(relType, 2, size(relType)-3) AS relType, propertyName, propertyTypes, mandatory\nCALL {\n\tWITH relType, propertyName\n\tMATCH (n)-[r]->(m) WHERE type(r) = relType AND (r[propertyName] IS NOT NULL OR propertyName IS NULL)\n\tWITH n, r, m\n\t// LIMIT\n\tWITH DISTINCT labels(n) AS from, labels(m) AS to\n\tRETURN from, to\n}\nRETURN DISTINCT from, to, relType, propertyName, propertyTypes, mandatory\nORDER BY relType ASC\n";
            if (config.sampleOnly()) {
                return template.replace("// LIMIT\n", "LIMIT " + DEFAULT_SAMPLE_SIZE + "\n");
            }
            return template;
        }

        private Map<Ref, NodeObjectType> getNodeObjectTypes(UnaryOperator<String> idGenerator, Map<String, Token> labelIdToToken) throws Exception {
            if (labelIdToToken.isEmpty()) {
                return Map.of();
            }
            String query = "CALL db.schema.nodeTypeProperties()\nYIELD nodeType, nodeLabels, propertyName, propertyTypes, mandatory\nRETURN *\nORDER BY nodeType ASC\n";
            LinkedHashMap<Ref, NodeObjectType> nodeObjectTypes = new LinkedHashMap<Ref, NodeObjectType>();
            this.transaction.execute(query).accept(resultRow -> {
                List nodeLabels = ((List)resultRow.get("nodeLabels")).stream().sorted().toList();
                Ref id = new Ref((String)idGenerator.apply(resultRow.getString("nodeType")));
                NodeObjectType nodeObject = nodeObjectTypes.computeIfAbsent(id, key -> new NodeObjectType(key.value, nodeLabels.stream().map(l -> new Ref(((Token)labelIdToToken.get((Object)l)).id)).toList()));
                this.extractProperty(resultRow).ifPresent(nodeObject.properties()::add);
                return true;
            });
            return nodeObjectTypes;
        }

        private Map<Ref, RelationshipObjectType> getRelationshipObjectTypes(UnaryOperator<String> nodeObjectTypeIdGenerator, BinaryOperator<String> idGenerator, Map<String, Token> relationshipIdToToken) throws Exception {
            if (relationshipIdToToken.isEmpty()) {
                return Map.of();
            }
            String query = Introspector.getRelationshipPropertiesQuery(this.config);
            LinkedHashMap<Ref, RelationshipObjectType> relationshipObjectTypes = new LinkedHashMap<Ref, RelationshipObjectType>();
            this.transaction.execute(query).accept(resultRow -> {
                String relType = resultRow.getString("relType");
                String from = (String)nodeObjectTypeIdGenerator.apply(":" + ((List)resultRow.get("from")).stream().sorted().map(v -> "`" + v + "`").collect(Collectors.joining(":")));
                String to = (String)nodeObjectTypeIdGenerator.apply(":" + ((List)resultRow.get("to")).stream().sorted().map(v -> "`" + v + "`").collect(Collectors.joining(":")));
                Ref id = new Ref((String)idGenerator.apply(relType, to));
                RelationshipObjectType relationshipObject = relationshipObjectTypes.computeIfAbsent(id, key -> new RelationshipObjectType(key.value, new Ref(((Token)relationshipIdToToken.get(relType)).id()), new Ref(from), new Ref(to)));
                this.extractProperty(resultRow).ifPresent(relationshipObject.properties()::add);
                return true;
            });
            return relationshipObjectTypes;
        }

        Optional<Property> extractProperty(Result.ResultRow resultRow) {
            String propertyName = resultRow.getString("propertyName");
            if (propertyName == null) {
                return Optional.empty();
            }
            List<Type> types = ((List)resultRow.get("propertyTypes")).stream().map(t -> {
                String type;
                String itemType = null;
                if (t.endsWith("Array")) {
                    type = "array";
                    itemType = t.replace("Array", "");
                    itemType = TYPE_MAPPING.getOrDefault(itemType, itemType).toLowerCase(Locale.ROOT);
                } else {
                    type = TYPE_MAPPING.getOrDefault(t, (String)t).toLowerCase(Locale.ROOT);
                }
                return new Type(type, itemType);
            }).toList();
            return Optional.of(new Property(propertyName, types, resultRow.getBoolean("mandatory")));
        }

        private static String splitStripAndJoin(String value, String prefix) {
            return Arrays.stream(value.split(":")).map(String::trim).filter(Predicate.not(String::isBlank)).map(t -> ENCLOSING_TICK_MARKS.matcher((CharSequence)t).replaceAll(m -> m.group(1))).collect(Collectors.joining(":", prefix + ":", ""));
        }

        private static /* synthetic */ String lambda$getRelationshipTypes$3(String rec$, Object xva$0) {
            return "rt:%s".formatted(xva$0);
        }

        private static /* synthetic */ String lambda$getNodeLabels$1(String rec$, Object xva$0) {
            return "nl:%s".formatted(xva$0);
        }

        private static class CachingUnaryOperator<T>
        implements UnaryOperator<T> {
            private final Map<T, T> cache = new HashMap<T, T>();
            private final UnaryOperator<T> delegate;

            CachingUnaryOperator(UnaryOperator<T> delegate) {
                this.delegate = delegate;
            }

            @Override
            public T apply(T s) {
                return this.cache.computeIfAbsent(s, this.delegate);
            }
        }

        private static class NodeObjectIdGenerator
        implements UnaryOperator<String> {
            private final boolean useConstantIds;

            NodeObjectIdGenerator(boolean useConstantIds) {
                this.useConstantIds = useConstantIds;
            }

            @Override
            public String apply(String nodeType) {
                if (this.useConstantIds) {
                    return Introspector.splitStripAndJoin(nodeType, "n");
                }
                return ID_GENERATOR.get();
            }
        }

        private static class RelationshipObjectIdGenerator
        implements BinaryOperator<String> {
            private final boolean useConstantIds;
            private final Map<String, Map<String, Integer>> counter = new HashMap<String, Map<String, Integer>>();

            RelationshipObjectIdGenerator(boolean useConstantIds) {
                this.useConstantIds = useConstantIds;
            }

            @Override
            public String apply(String relType, String target) {
                if (this.useConstantIds) {
                    String id = Introspector.splitStripAndJoin(relType, "r");
                    Map count = this.counter.computeIfAbsent(id, ignored -> new HashMap());
                    if (count.isEmpty()) {
                        count.put(target, 0);
                        return id;
                    }
                    if (count.containsKey(target)) {
                        Integer value = (Integer)count.get(target);
                        return value == 0 ? id : id + "_" + value;
                    }
                    int newValue = count.size();
                    count.put(target, newValue);
                    return id + "_" + newValue;
                }
                return ID_GENERATOR.get();
            }
        }
    }

    record RelationshipObjectType(String id, Ref type, Ref from, Ref to, List<Property> properties) {
        RelationshipObjectType(String id, Ref type, Ref from, Ref to) {
            this(id, type, from, to, new ArrayList<Property>());
        }
    }

    record Ref(String value) {
    }

    record Token(String id, String value) {
    }

    record NodeObjectType(String id, List<Ref> labels, List<Property> properties) {
        NodeObjectType(String id, List<Ref> labels) {
            this(id, labels, new ArrayList<Property>());
        }
    }

    record Property(String token, List<Type> types, boolean mandatory) {
    }

    record Type(String value, String itemType) {
    }
}

