/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.neo4j.collection.AbstractPrefetchingRawIterator;
import org.neo4j.collection.RawIterator;
import org.neo4j.exceptions.KernelException;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.CallableUserAggregationFunction;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.logging.InternalLog;
import org.neo4j.procedure.impl.ProcedureCompiler;

class ProcedureJarLoader {
    private final ProcedureCompiler compiler;
    private final InternalLog log;

    ProcedureJarLoader(ProcedureCompiler compiler, InternalLog log) {
        this.compiler = compiler;
        this.log = log;
    }

    Callables loadProceduresFromDir(Path root) throws IOException, KernelException {
        if (root == null || Files.notExists(root, new LinkOption[0])) {
            return Callables.empty();
        }
        ArrayList<Path> jarFiles = new ArrayList<Path>();
        ArrayList<String> failedJarFiles = new ArrayList<String>();
        try (DirectoryStream<Path> list = Files.newDirectoryStream(root, "*.jar");){
            for (Path path : list) {
                if (this.isInvalidJarFile(path)) {
                    failedJarFiles.add(path.getFileName().toString());
                }
                jarFiles.add(path);
            }
        }
        if (!failedJarFiles.isEmpty()) {
            throw new ZipException(String.format("Some jar procedure files (%s) are invalid, see log for details.", String.join((CharSequence)", ", failedJarFiles)));
        }
        if (jarFiles.size() == 0) {
            return Callables.empty();
        }
        URL[] jarFilesURLs = (URL[])jarFiles.stream().map(this::toURL).toArray(URL[]::new);
        URLClassLoader loader = new URLClassLoader(jarFilesURLs, this.getClass().getClassLoader());
        Callables out = new Callables();
        for (Path jarFile : jarFiles) {
            this.loadProcedures(jarFile, loader, out);
        }
        return out;
    }

    private boolean isInvalidJarFile(Path jarFile) {
        try {
            new JarFile(jarFile.toFile(), true, 1, JarFile.runtimeVersion()).close();
            return false;
        }
        catch (IOException e) {
            this.log.error(String.format("Plugin jar file: %s corrupted.", jarFile));
            return true;
        }
    }

    private Callables loadProcedures(Path jar, ClassLoader loader, Callables target) throws IOException, KernelException {
        RawIterator<Class<?>, IOException> classes = this.listClassesIn(jar, loader);
        while (classes.hasNext()) {
            Class next = (Class)classes.next();
            target.addAllProcedures(this.compiler.compileProcedure(next, null, false));
            target.addAllFunctions(this.compiler.compileFunction(next, false));
            target.addAllAggregationFunctions(this.compiler.compileAggregationFunction(next));
        }
        return target;
    }

    private URL toURL(Path f) {
        try {
            return f.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private RawIterator<Class<?>, IOException> listClassesIn(final Path jar, final ClassLoader loader) throws IOException {
        final JarFile jarFile = new JarFile(jar.toFile(), true, 1, JarFile.runtimeVersion());
        final Iterator jarEntries = jarFile.versionedStream().iterator();
        return new AbstractPrefetchingRawIterator<Class<?>, IOException>(){

            protected Class<?> fetchNextOrNull() throws IOException {
                try {
                    while (jarEntries.hasNext()) {
                        JarEntry nextEntry = (JarEntry)jarEntries.next();
                        String name = nextEntry.getName();
                        if (!name.endsWith(".class")) continue;
                        String className = name.substring(0, name.length() - ".class".length()).replace('/', '.');
                        try {
                            Class<?> aClass = loader.loadClass(className);
                            aClass.getDeclaredMethods();
                            aClass.getDeclaredFields();
                            return aClass;
                        }
                        catch (Exception | LinkageError e) {
                            ProcedureJarLoader.this.log.warn("Failed to load `%s` from plugin jar `%s`: %s: %s", new Object[]{className, jar, e.getClass().getName(), e.getMessage()});
                        }
                    }
                    jarFile.close();
                    return null;
                }
                catch (IOException | RuntimeException e) {
                    jarFile.close();
                    throw e;
                }
            }
        };
    }

    public static class Callables {
        private final List<CallableProcedure> procedures = new ArrayList<CallableProcedure>();
        private final List<CallableUserFunction> functions = new ArrayList<CallableUserFunction>();
        private final List<CallableUserAggregationFunction> aggregationFunctions = new ArrayList<CallableUserAggregationFunction>();
        private static final Callables EMPTY = new Callables();

        public void add(CallableProcedure proc) {
            this.procedures.add(proc);
        }

        public void add(CallableUserFunction func) {
            this.functions.add(func);
        }

        public List<CallableProcedure> procedures() {
            return this.procedures;
        }

        public List<CallableUserFunction> functions() {
            return this.functions;
        }

        public List<CallableUserAggregationFunction> aggregationFunctions() {
            return this.aggregationFunctions;
        }

        void addAllProcedures(List<CallableProcedure> callableProcedures) {
            this.procedures.addAll(callableProcedures);
        }

        void addAllFunctions(List<CallableUserFunction> callableFunctions) {
            this.functions.addAll(callableFunctions);
        }

        void addAllAggregationFunctions(List<CallableUserAggregationFunction> callableFunctions) {
            this.aggregationFunctions.addAll(callableFunctions);
        }

        public static Callables empty() {
            return EMPTY;
        }
    }
}

