/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.time.ZoneId;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;
import org.neo4j.procedure.builtin.ProceduresTimeFormatHelper;

public class ListConnectionResult {
    public final String connectionId;
    public final String connectTime;
    public final String connector;
    public final String username;
    public final String userAgent;
    public final String serverAddress;
    public final String clientAddress;

    ListConnectionResult(TrackedNetworkConnection connection, ZoneId timeZone) {
        this.connectionId = connection.id();
        this.connectTime = ProceduresTimeFormatHelper.formatTime(connection.connectTime(), timeZone);
        this.connector = connection.connectorId();
        this.username = connection.username();
        this.userAgent = connection.userAgent();
        this.serverAddress = SocketAddress.format((java.net.SocketAddress)connection.serverAddress());
        this.clientAddress = SocketAddress.format((java.net.SocketAddress)connection.clientAddress());
    }
}

