/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.logging.InternalLog;
import org.neo4j.util.VisibleForTesting;

class ProcedureClassLoader
extends URLClassLoader {
    public static Result setup(Collection<Path> jars, InternalLog log, boolean procedureReloadEnabled) throws ZipException, ProcedureException {
        return ProcedureClassLoader.setup(ProcedureClassLoader.class.getClassLoader(), jars, log, procedureReloadEnabled);
    }

    @VisibleForTesting
    static Result setup(ClassLoader parent, Collection<Path> jars, InternalLog log, boolean procedureReloadEnabled) throws ZipException, ProcedureException {
        ProcedureClassLoader loader = new ProcedureClassLoader((URL[])jars.stream().map(ProcedureClassLoader::toURL).toArray(URL[]::new), parent);
        ClassResolver extensionResolver = loader::loadClass;
        ClassResolver extensionlessResolver = procedureReloadEnabled ? loader::preload : loader::loadClass;
        ClassEnumeration classes = ProcedureClassLoader.enumerateClasses(jars, log);
        List<Entry> entries = ProcedureClassLoader.resolveAll(classes, log, extensionResolver, extensionlessResolver);
        return new Result(loader, entries);
    }

    private ProcedureClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    private Class<?> preload(String name) throws ClassNotFoundException {
        Class<?> klass = super.findLoadedClass(name);
        if (klass != null) {
            return klass;
        }
        klass = this.findClass(name);
        this.resolveClass(klass);
        return klass;
    }

    private static List<Entry> resolveAll(ClassEnumeration enumeration, InternalLog log, ClassResolver extensionResolver, ClassResolver extensionlessResolver) throws ProcedureException {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        entries.addAll(ProcedureClassLoader.resolve(enumeration.withoutExtensions, log, extensionlessResolver));
        entries.addAll(ProcedureClassLoader.resolve(enumeration.withExtensions, log, extensionResolver));
        return entries;
    }

    private static List<Entry> resolve(Map<String, Path> classes, InternalLog log, ClassResolver method) throws ProcedureException {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (Map.Entry<String, Path> entry : classes.entrySet()) {
            Class<?> klass;
            String className = entry.getKey();
            Path jar = entry.getValue().toAbsolutePath();
            try {
                klass = method.resolve(entry.getKey());
            }
            catch (ClassNotFoundException exc) {
                exceptions.add(exc);
                continue;
            }
            catch (IllegalAccessError exc) {
                ProcedureClassLoader.logWarning(log, className, jar, exc);
                exceptions.add(exc);
                continue;
            }
            catch (NoClassDefFoundError exc) {
                ProcedureClassLoader.logWarning(log, className, jar, exc);
                continue;
            }
            catch (LinkageError exc) {
                ProcedureClassLoader.logWarning(log, className, jar, exc);
                continue;
            }
            try {
                klass.getDeclaredClasses();
                klass.getDeclaredMethods();
                klass.getDeclaredFields();
                entries.add(new Entry(jar, klass));
            }
            catch (Exception | LinkageError exc) {
                ProcedureClassLoader.logWarning(log, className, jar, exc);
            }
        }
        if (!exceptions.isEmpty()) {
            ProcedureException exc = new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Failed to register procedures for the following reasons:", new Object[0]);
            for (Throwable exception : exceptions) {
                exc.addSuppressed(exception);
            }
            throw exc;
        }
        return entries;
    }

    private static void logWarning(InternalLog log, String className, Path jar, Throwable exc) {
        log.warn("Failed to load `%s` from plugin jar `%s`: %s: %s", new Object[]{className, jar, exc.getClass().getName(), exc.getMessage()});
    }

    private static URL toURL(Path f) {
        try {
            return f.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static ClassEnumeration enumerateClasses(Collection<Path> jars, InternalLog log) throws ZipException {
        ClassEnumeration out = new ClassEnumeration(new HashMap<String, Path>(), new HashMap<String, Path>());
        ArrayList<String> invalidFiles = new ArrayList<String>();
        for (Path pth : jars) {
            try {
                JarFile jf = ProcedureClassLoader.open(pth);
                try {
                    Content content = ProcedureClassLoader.listClasses(jf);
                    Map<String, Path> destination = content.hasExtension ? out.withExtensions : out.withoutExtensions;
                    for (String klass : content.classes()) {
                        destination.put(klass, pth);
                    }
                }
                finally {
                    if (jf == null) continue;
                    jf.close();
                }
            }
            catch (IOException exc) {
                log.error(String.format("Plugin jar file: %s corrupted.", pth));
                invalidFiles.add(pth.getFileName().toString());
            }
        }
        if (!invalidFiles.isEmpty()) {
            throw new ZipException(String.format("Some jar procedure files (%s) are invalid, see log for details.", String.join((CharSequence)", ", invalidFiles)));
        }
        return out;
    }

    private static Content listClasses(JarFile jf) {
        boolean hasExtension;
        ArrayList<String> classes = new ArrayList<String>();
        Iterator it = jf.versionedStream().iterator();
        boolean bl = hasExtension = jf.getEntry("META-INF/services/" + ExtensionFactory.class.getCanonicalName()) != null;
        while (it.hasNext()) {
            JarEntry entry = (JarEntry)it.next();
            String name = entry.getName();
            if (!name.endsWith(".class")) continue;
            classes.add(ProcedureClassLoader.qualifiedName(name));
        }
        return new Content(classes, hasExtension);
    }

    private static String qualifiedName(String name) {
        return name.substring(0, name.length() - ".class".length()).replace('/', '.');
    }

    private static JarFile open(Path pth) throws IOException {
        Objects.requireNonNull(pth);
        return new JarFile(pth.toFile(), true, 1, JarFile.runtimeVersion());
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    public record Result(ProcedureClassLoader loader, List<Entry> loadedClasses) {
    }

    private static interface ClassResolver {
        public Class<?> resolve(String var1) throws ClassNotFoundException;
    }

    private record ClassEnumeration(Map<String, Path> withExtensions, Map<String, Path> withoutExtensions) {
    }

    public record Entry(Path jar, Class<?> cls) {
    }

    private record Content(List<String> classes, boolean hasExtension) {
    }
}

